package com.xiaomai.cases.polar.applet;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 15:59
 */
public class TestChooseUseXcx extends XMBaseTest {
    AppletTools appletTools = new AppletTools();
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_chooseUseXcx")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "选择要使用的小程序")
    public void testChooseUseXcx(){
        String appId = appletTools.getAuthDetail().getJSONObject("result").getString("appId");
        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        if(appId.equals("wx8f7b6ffc0c1f2c96")){
            object.put("exclusiveXcx",true);
        }
        else {
            object.put("exclusiveXcx",false);
        }

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
    }

}
