package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestCancel extends XMBaseTest {

    String memberId;

    String cardId;
    Tools tools=new Tools();

    OrderTools orderTools=new OrderTools();

    CardTools cardTools=new CardTools();


    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_cancel")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "取消订单")
    public void testCancel(){


        String name = "创建订单潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //获取会员ID
        int memberTotal = Integer.parseInt(tools.search("NORMAL","NORMAL").getJSONObject("result").getString("total"));
        if (memberTotal == 0) {
            memberId = tools.create(name,phone).getString("result");
        }
        memberId=tools.search("NORMAL","NORMAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        //获取会员卡信息
        //获取会员卡列表
        int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard().getJSONObject("result").getString("total"));
        if (cardTotal == 0) {
            cardId = cardTools.memberCardCreate("创建订单会员卡"+ TimeUtils.getCurrentTime()).getString("result");
        }
        JSONObject memberCard=orderTools.fetchPageOfMemberCard();
        cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        int quantity= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("balance"));
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //检查会员对该卡是否超出购买上限
        boolean limitResult=orderTools.checkAllowPurchase("MEMBER_CARD",cardId,memberId,"1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        if(limitResult == true) {

            //创建待支付订单
            JSONObject orderResult=orderTools.signOrder(cardId,latestSnapshotId,quantity,price,validPeriod,latestSnapshotId, price/2,"PURCHASE",
                    "MEMBER_CARD",memberId,price-price/2,0,"1");
            String success=orderResult.getString("success");
            String getDetailId=orderResult.getString("result");
            Assert.assertEquals(success,"true","创建待支付订单失败");


            //获取订单详情
            JSONObject getDetailResult=orderTools.getDetail(getDetailId);
            String id = getDetailResult.getJSONObject("result").getString("id");//订单id
            String state=getDetailResult.getJSONObject("result").getString("state");

            Assert.assertEquals(id.equals(getDetailId),true,"获取创建的订单详情失败");
            Assert.assertEquals(state,"WAITING","获取创建的订单状态未是待支付");


            //取消订单
            JSONObject cancel=orderTools.cancel(getDetailId);
            String cancelSuccess=cancel.getString("success");
            Assert.assertEquals(cancelSuccess,"true","取消待支付订单失败");

            //获取订单详情
            JSONObject getDetailResult1=orderTools.getDetail(getDetailId);
            String id1 = getDetailResult1.getJSONObject("result").getString("id");//订单id
            String state1=getDetailResult1.getJSONObject("result").getString("state");

            Assert.assertEquals(id1.equals(getDetailId),true,"获取取消的订单详情失败");
            Assert.assertEquals(state1,"CANCEL","获取取消的订单状态未是已取消");


        }


    }
}
