package com.xiaomai.cases.polar.schedule.group;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.cases.polar.setting.venue.VenueAreaTools;

import com.xiaomai.utils.CommUtil;
import org.testng.annotations.BeforeClass;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 创建排课通用类
 * @author adu
 * data 2024/7/2 10:54
 */

public class UniversalDataScheduling extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;
    String courseName = "阿杜自动化团课课程";
    String courseId = "";
    String chiefCoachIdS = "";
    List<String> venueAreaIds = null;
    List<String> assistCoachIdS = null;

    @BeforeClass
    public void beforeTest() {
        super.beforeTest();
        //获取存量课程ID
        courseId = groupScheduleTools.getStockGroupCourseId(courseName);
        if (courseId == "") {
            //获取存量课程分类ID
            String categoryId = courseCategoryTools.getCourseCategoryPage("普拉提");
            courseId = courseTools.createGroupCourse(courseName, categoryId, "STUDIO");
        }
        //获取存量场地
        venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        //获取存量教练
        List<String> chiefCoachId = new ArrayList<>();
        chiefCoachId.add("杜君丽");
        chiefCoachIdS = groupScheduleTools.getStudioAdminId(chiefCoachId).get(0).toString();
        //获取存量助教
        List<String> assistCoachIds = new ArrayList<>();
        assistCoachIds.add("木头");
        assistCoachIds.add("吴彦祖");
        assistCoachIdS = groupScheduleTools.getStudioAdminId(assistCoachIds);
        //创建排课(按次数)
        groupScheduleTools.createGroupRuleSchedule(courseId, chiefCoachIdS, CommUtil.oneKeyGetNextWeekStartDay(), CommUtil.oneKeyGetNextWeekEndDay(), venueAreaIds, assistCoachIdS, true, 2, 780);

    }
}

    