package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestGetShareDetail extends XMBaseTest {
    @Resource(name = "luckyDrawTools")
    LuckyDrawTools luckyDrawTools;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getShareDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "分享幸运抽奖海报")
    public void testGetShareDetail()throws InterruptedException{

        //创建自定义奖品
        String prizeName = "奖品" + RandomStringUtil.randomString(5);
        String prizeId = luckyDrawTools.addCustomizePrize(prizeName);
        //创建活动名称
        String activityName = "每人每日抽100次" + RandomStringUtil.randomString(5);
        //创建已发布的活动
        String activityId = luckyDrawTools.addLuckyDraw("CUSTOMIZE_GIFT",prizeName,prizeId,true,activityName);

        //构建参数
        JSONObject body = new JSONObject();
        JSONObject extJson = new JSONObject();
        extJson.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        extJson.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("bizId", activityId);
        body.put("shareType", "LUCKY_DRAW");
        body.put("extJson", extJson);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.studioId"),xmAppApi.getLoginInfo().getStudioId());

        //清理数据
        //删除活动
        luckyDrawTools.deleteLuckyDraw(activityId);
        Thread.sleep(2000);
        //删除自定义奖品
        luckyDrawTools.delCustomizePrize(prizeId);
    }


}
