package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.minMemberCard.MinCardTools;
import com.xiaomai.cases.lunar.order.OrderCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.coupon.CouponTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestLuckyDrawLottery extends XMBaseTest {
    @Resource(name = "luckyDrawTools")
    LuckyDrawTools luckyDrawTools;
    @Resource(name = "userTools")
    UserTools userTools;
    @Resource(name = "couponTools")
    CouponTools couponTools;
    @Resource(name = "cardTools")
    CardTools cardTools;
    @Resource(name = "minCardTools")
    MinCardTools minCardTools;
    @Resource(name = "orderCTools")
    OrderCTools orderCTools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    DataUserInfo info = new DataUserInfo();
    public String prizeId;
    public String prizeName;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_LuckyDraw)
                .setApiName("API_luckyDrawLottery")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "参与抽奖-抽中优惠券")
    public void testLuckyDrawLottery_coupon()throws InterruptedException{
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);
        //查询用于营销的优惠券数量
        int total = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getStudioCouponList("yx优惠券",info),"$.result.total"));
        if(total==0){
            //创建1张优惠券
            prizeName = "yx优惠券" + RandomStringUtil.randomString(5);
            prizeId = couponTools.createStudioCoupon("WITHOUT",prizeName,true,info);
        }
        prizeId = XMJSONPath.readPath(luckyDrawTools.getStudioCouponList("yx优惠券",info),"$.result.records[0].id");
        prizeName = XMJSONPath.readPath(luckyDrawTools.getStudioCouponList("yx优惠券",info),"$.result.records[0].name");

        //创建活动名称
        String activityName = "每人每天抽优惠券" + RandomStringUtil.randomString(5);
        //创建活动=未开始
        String activityId = luckyDrawTools.addLuckyDraw("COUPON",prizeName,prizeId,true,activityName,info);
        Thread.sleep(1000);
        String prizeNo = XMJSONPath.readPath(luckyDrawTools.getLuckyDrawDetail(activityId,info),"$.result.prizeList[0].id");
        //编辑活动=进行中（主要是改活动开始时间）
        luckyDrawTools.editLuckyDraw("COUPON",prizeNo,prizeName,prizeId,true,activityId,activityName,info);
        //获取会员信息
        String memberId = userTools.getMemberInfo().getString("memberId");
        //当前我的抽奖次数
        int drawNum = luckyDrawTools.getDrawNum(activityId,memberId);
        //当前我的活动数量
        int activityNum = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActivityByPage(memberId),"$.result.total"));
        //当前我的优惠券数量
        int couponNum = luckyDrawTools.countMemberReceivedCoupon(memberId);

        JSONObject body = new JSONObject();
        body.put("id",activityId);
        body.put("memberId",memberId);

        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
        //100%中奖
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.winPrize"),"true");
        //抽奖次数-1
        Assert.assertTrue(luckyDrawTools.getDrawNum(activityId,memberId)==drawNum-1);
        //我的奖品+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActPrizeByPage(activityId,memberId),"$.result.total"))==1);
        //我的活动+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActivityByPage(memberId),"$.result.total"))==activityNum+1);
        //我的优惠券+1
        Assert.assertTrue(luckyDrawTools.countMemberReceivedCoupon(memberId)==couponNum+1);

        //app奖品消耗
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyPrizeCount(activityId,info),"$.result[0].winCount"))==1);//已抽中1个
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyPrizeCount(activityId,info),"$.result[0].stock"))==99);//剩余99个
        //app参与记录
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyAttendByPage(activityId,info),"$.result.total"))==1);//参与人员1个

        //清理数据
        //会员详情-优惠券-作废优惠券
        String goalRecordId = XMJSONPath.readPath(couponTools.pageMemberReceivedCoupon(memberId,"AVAILABLE",info),"$.result.records[0].id");
        Thread.sleep(1000);
        couponTools.abandonMembercouponReceiveRecord(goalRecordId,info);
    }
    @Test(description = "参与抽奖-抽奖体验卡")
    public void testLuckyDrawLottery_experienceCard()throws InterruptedException{
        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);
        //查询用于营销的体验卡数量
        int total = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getPageOfMemberCard("yx体验卡",info),"$.result.total"));
        if(total==0){
            //创建1张体验卡
            prizeName = "yx体验卡" + RandomStringUtil.randomString(5);
            JSONObject benefit = new JSONObject();
            benefit.put("identifier", RandomStringUtil.randomString(20));
            benefit.put("benefitType", "BALANCE");
            benefit.put("targetScope","GROUP_CLASS_AND_PERSONAL_COURSE");
            benefit.put("balance","3");//使用次数
            benefit.put("reserveLimitType","UN_LIMIT");//预约次数限制：不限制
            benefit.put("reserveLimitNumber",0);
            benefit.put("defaultConsumeBalance",1);//扣除次数
            benefit.put("itemList",new JSONArray());
            benefit.put("targetType","COURSE");
            benefit.put("price","10");
            prizeId = cardTools.experienceCardCreate(prizeName,"10",benefit,info);
        }
        prizeId = XMJSONPath.readPath(luckyDrawTools.getPageOfMemberCard("yx体验卡",info),"$.result.records[0].id");
        prizeName = XMJSONPath.readPath(luckyDrawTools.getPageOfMemberCard("yx体验卡",info),"$.result.records[0].name");

        //创建活动名称
        String activityName = "每人每天抽体验卡" + RandomStringUtil.randomString(5);
        //创建活动=未开始
        Thread.sleep(4000);
        String activityId = luckyDrawTools.addLuckyDraw("EXPERIENCE_CARD",prizeName,prizeId,true,activityName,info);
        Thread.sleep(1000);
        String prizeNo = XMJSONPath.readPath(luckyDrawTools.getLuckyDrawDetail(activityId,info),"$.result.prizeList[0].id");
        //编辑活动=进行中（主要是改活动开始时间）
        luckyDrawTools.editLuckyDraw("EXPERIENCE_CARD",prizeNo,prizeName,prizeId,true,activityId,activityName,info);
        //获取会员信息
        String memberId = userTools.getMemberInfo().getString("memberId");
        //当前我的抽奖次数
        int drawNum = luckyDrawTools.getDrawNum(activityId,memberId);
        //当前我的活动数量
        int activityNum = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActivityByPage(memberId),"$.result.total"));
        //当前我的卡包数量
        int cardNum = minCardTools.countMyUsableCard(memberId);
        //当前我的订单
        int orderNum = Integer.parseInt(XMJSONPath.readPath(orderCTools.pageOrder(memberId),"$.result.total"));

        JSONObject body = new JSONObject();
        body.put("id",activityId);
        body.put("memberId",memberId);

        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
        //100%中奖
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.winPrize"),"true");
        //抽奖次数-1
        Assert.assertTrue(luckyDrawTools.getDrawNum(activityId,memberId)==drawNum-1);
        //我的奖品+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActPrizeByPage(activityId,memberId),"$.result.total"))==1);
        //我的活动+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActivityByPage(memberId),"$.result.total"))==activityNum+1);
        //我的卡包+1
        Assert.assertTrue(minCardTools.countMyUsableCard(memberId)==cardNum+1);
        //我的订单+1
        String voucherId = XMJSONPath.readPath(orderCTools.pageOrder(memberId),"$.result.records[0].id");
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(orderCTools.pageOrder(memberId),"$.result.total"))==orderNum+1);

        //app奖品消耗，参与记录
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyPrizeCount(activityId,info),"$.result[0].winCount"))==1);//已抽中1个
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyPrizeCount(activityId,info),"$.result[0].stock"))==99);//剩余99个
        //app参与记录
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyAttendByPage(activityId,info),"$.result.total"))==1);//参与人员1个

        //清理数据
        //作废体验卡订单
        orderTools.discard(voucherId,"其他","自动化作废订单",info);
    }

}
