package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-02-29  10:00
 * @Description: 员工工具类
 * @Version: 1.0
 */
@Component("adminTools")
public class AdminTools extends XMBaseTest {
    /**
     * @description:添加员工
     * @author: xuyamei
     * @date:  2024/2/29 13:59
     * @param role：角色
     * @param dataUserInfos
     * @return: com.alibaba.fastjson.JSONObject  返回的是请求参数
     **/
    public JSONObject addStudioAdmin(String role, DataUserInfo...dataUserInfos){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_addStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("phone", RandomStringUtil.randomMobile("100"));
        String name = RandomStringUtil.random_name();
        body.put("name", name);
        body.put("nickName", name);
        JSONObject avatar = new JSONObject();
        avatar.put("content",name.charAt(name.length() - 1));
        body.put("avatar",avatar);  // 员工头像未设置取昵称最后一个字
        body.put("gender","MAN");

        JSONArray roles = new JSONArray();  // 角色
        JSONObject teaching = new JSONObject();
        JSONArray coachTeachingTypes = new JSONArray(); // LEAGUE_CLASS, PERSONAL_TRAINERS, TRAINING_CAMP   "团课", "私教", "训练营"

        switch(role){
            case "教练":
                roles.add("StudioCoach");
                body.put("roles", roles);
                teaching.put("teaching", true); // 是否授课,为true需要传授课的类型
                coachTeachingTypes.add("LEAGUE_CLASS");  // 团课
                coachTeachingTypes.add("PERSONAL_TRAINERS");  //私教
                coachTeachingTypes.add("TRAINING_CAMP");  //训练营
                teaching.put("coachTeachingTypes",coachTeachingTypes);
                body.put("teaching",teaching);
                break;
            case "销售主管":
                roles.add("StudioSaleManager");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);
                break;
            case "财务":
                roles.add("StudioFinance");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);
                break;
            case "前台":
                roles.add("StudioReception");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);
                break;
            default: // 默认店长
                roles.add("StudioOwner");
                teaching.put("teaching", false);
                body.put("teaching",teaching); // 是否授课
                body.put("roles", roles);

        }

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return body;
    }

    /**
     * @description:检验员工手机号是否存在
     * @author: xuyamei
     * @date:  2024/2/29 14:04
     * @param phone
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject checkExistInStudio(String phone){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_checkExistInStudio")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();
        String body = "{\"phone\": \""+phone+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:获取员工信息
     * @author: xuyamei
     * @date:  2024/2/29 16:47
     * @param adminId:员工id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getStudioAdmin(String adminId){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_getStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        String body = "{\"id\":\""+adminId+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @description:查询员工列表数据
     * @author: xuyamei
     * @date:  2024/2/29 17:58
     * @param body：请求参数
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject pageStudioAdmin(String body){
        dataApi.setApiModule(ApiModule.Polar_Admin)
                .setApiName("API_pageStudioAdmin")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
