package com.xiaomai.cases.lunar.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;

import java.math.BigDecimal;

public class OrderCTools extends XMBaseTest {

    /**
     * @param
     * @description:C端购买0元卡
     * @param activatePattern [ "即时生效", "首次使用生效", "指定日期生效" ] 激活方式[ PURCHASE, FIRST_USED, SPECIFIC_DATE ]
     * @param cardId 卡id
     * @param cardSnapshotId:卡快照id
     * @param memberId:会员id
     * @param receivableAmount:应收金额
     * @author: yangfangfang
     **/
    public JSONObject purchaseCard(String activatePattern, String cardId, String cardSnapshotId, String memberId, BigDecimal receivableAmount, String commodityCardType,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Order)
                .setApiName("API_purchaseCard")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activatePattern",activatePattern);
        jsonObject.put("cardId",cardId);
        jsonObject.put("cardSnapshotId",cardSnapshotId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("memo", "");
        jsonObject.put("receivableAmount",receivableAmount);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("objectId", RandomStringUtil.randomString(16));


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取C端订单详情
     * @param id 订单ID
     * @author: yangfangfang
     **/
    public JSONObject getDetail(String id,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Order)
                .setApiName("API_getDetail")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取C端我的订单列表
     * @param receiverId 会员ID
     * @author: yangfangfang
     **/
    public JSONObject pageOrder(String receiverId,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Order)
                .setApiName("API_pageOrder")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("receiverId",receiverId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description C端取消订单
     * @param id 订单ID
     * @author: yangfangfang
     **/
    public JSONObject cancel(String id,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Lunar_Order)
                .setApiName("API_cancel")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }
}
