package com.xiaomai.cases.polar.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-13  11:48
 * @Description:获取充值记录
 * @Version: 1.0
 */

public class TestGetSmsRechargePage extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_getSmsRechargePage")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取充值记录")
    public void testGetSmsRechargePage(){

        JSONObject object = new JSONObject();
        JSONArray studioIds = new JSONArray();
        studioIds.add(xmAppApi.getLoginInfo().getStudioId());
        object.put("current",0);
        object.put("size",20);
        object.put("studioIds",studioIds);

        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
        int total = Integer.parseInt(XMJSONPath.readPath(response,"$.result.total"));
        Assert.assertTrue(total >= 0);
    }
}

