package com.xiaomai.cases.polar.setting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.util.ArrayList;
import java.util.List;

public class TagTools extends XMBaseTest {

    /**
     * @param
     * @description:添加标签
     * @author: yangfangfang
     * @date: 2024/3/5 11:28
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject tagCreate(String label, DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_create")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("label", label);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;

    }

    /**
     * @param
     * @description:删除未被使用的标签
     * @author: yangfangfang
     * @date: 2024/3/5 14:28
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject tagDelete(String id,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_deleteById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject deleteTag=new JSONObject();
        deleteTag.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        deleteTag.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        deleteTag.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        deleteTag.put("id",id);
        deleteTag.put("confirm","");

        dataApi.doRequest(RequestType.JSON, dataparams, deleteTag.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;

    }

    /**
     * @param
     * @description:删除已被本场馆使用的标签
     * @author: yangfangfang
     * @date: 2024/3/5 14:28
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject tagDelete_Used(String id,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_deleteById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject deleteTag1=new JSONObject();
        deleteTag1.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        deleteTag1.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        deleteTag1.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        deleteTag1.put("id",id);
        deleteTag1.put("confirm",true);

        dataApi.doRequest(RequestType.JSON, dataparams, deleteTag1.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;

    }

    /**
     * @param
     * @description:查询标签
     * @author: yangfangfang
     * @date: 2024/3/5 16:28
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject tagFetchPage(String content,DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_fetchPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("size",20);
        jsonObject.put("current",0);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("needUsageInfo","true");
        jsonObject.put("content",content);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;

    }


    /**
     * @param
     * @description:修改会员详情的标签
     * @author: yangfangfang
     * @date: 2024/3/16 16:28
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject forceUpdate(String memberId, String name, String phone, String status,String tagId, DataUserInfo...dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_forceUpdate")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject dataJson=new JSONObject();

        dataJson.put("memberId",memberId);
        dataJson.put("name",name);
        dataJson.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        dataJson.put("phone",phone);
        dataJson.put("status",status);
        dataJson.put("studioId",xmAppApi.getLoginInfo().getStudioId());

        List tags = new ArrayList();
        tags.add(tagId);
        dataJson.put("tags",tags);

        dataApi.doRequest(RequestType.JSON, dataparams, dataJson.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;

    }
}