package com.xiaomai.utils;

import java.io.*;

public class JsonAndFile {

    /**
     * 读文件
     * @return
     */
    public static String readFileToString(String caseName) {
        String fileName = String.format("%s_basedata.html", caseName);
        int len = 0;
        StringBuffer str = new StringBuffer();

        File file = new File("src/main/resources/baseresult/" + fileName);
        try {
            FileInputStream is = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(isr);
            String line = null;
            while ((line = in.readLine()) != null) {
                if (len != 0) { // 处理换行符的问题
                    str.append("\r\n" + line);
                } else {
                    str.append(line);
                }
                len++;
            }
            in.close();
            is.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return str.toString();
    }

    /**
     * 写文件
     * @param data
     */
    public static void WriteStringToFile(String data,String caseName) {
        String fileBaseDataName = String.format("%s_basedata.html", caseName);
        File fileBase = new File("src/main/resources/baseresult/" + fileBaseDataName);
        System.out.println(fileBase.getPath());
        if (!fileBase.exists()) { //如果存在不写入
            try {
                FileOutputStream fos = new FileOutputStream(fileBase.getPath());
                String s = data;
                if (s.isEmpty()){
                    return;
                }else {
                    fos.write(s.getBytes());
                    System.out.println("写入" + fileBaseDataName + "成功！");
                    fos.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                String fileContrastDataName=String.format("%s_contrastdata.html", caseName);
                File fileContrast = new File("src/main/resources/contrastresult/" + fileContrastDataName);
                FileOutputStream fos = new FileOutputStream(fileContrast.getPath());
                String s = data;
                if (s.isEmpty()){
                    return;
                }else {
                    fos.write(s.getBytes());
                    System.out.println("写入" + fileContrastDataName + "成功！");
                    fos.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 数据写入txt文件中
     * @param txtPath  duwen
     * @return
     */
    public static String readTxtFile(String txtPath){
//        String txtPath = "../../resources/token.txt";
        File file = new File(txtPath);
        if(file.isFile() && file.exists()){
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream,"UTF-8");
//                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
//                InputStreamReader isr = new InputStreamReader(new FileInputStream(file), "UTF-8");
                StringBuffer sb = new StringBuffer();
                String text = null;
                while((text = bufferedReader.readLine()) != null){
                    sb.append(text);
                }
                return sb.toString();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String readTxtFile(File file){
//        String txtPath = "../../resources/token.txt";
        if(file.isFile() && file.exists()){
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream,"UTF-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

                StringBuffer sb = new StringBuffer();
                String text = null;
                while((text = bufferedReader.readLine()) != null){
                    sb.append(text);
                }
                return sb.toString();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * 往txt文件中写入内容
     * @param txtPath  写文件路径
     * @param content  写入文件的内容
     */
    public static void writeTxt(String txtPath,String content){
        FileOutputStream fileOutputStream = null;
        File file = new File(txtPath);
        try {
            if(file.exists()){
                //判断文件是否存在，如果不存在就新建一个txt
                file.createNewFile();
            }
//            fileOutputStream = new FileOutputStream(file,IsAppend);//多个true就是追加
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(content.getBytes("utf-8"));
            fileOutputStream.flush();
            fileOutputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    public static void main(String[] args) {
        JsonAndFile filehandle = new JsonAndFile();
        System.out.println(System.getProperty("user.dir")+"/src/main/resources/token.txt");;
//        filehandle.writeTxt(System.getProperty("user.dir")+"/src/main/resources/token.txt","ttttttttttttttt");
        String token = filehandle.readTxtFile(System.getProperty("user.dir")+"/src/main/resources/token.txt");
        System.out.println(token);

    }

}