package com.xiaomai.cases.polar.data.financeData;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGetCostTrend extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getCostTrend")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{

                {"DAY","LEFT_AMOUNT", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//今天,待消耗金额
                {"MONTH","CONFIRMED_AMOUNT",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//本月,确认收入
                {"DAY","LEFT_AMOUNT", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime()},//今天,待消耗金额
                {"MONTH","CONFIRMED_AMOUNT",TimeUtils.getMonthLastDay(),TimeUtils.getMonthFristDay()},//本月,确认收入

        };
    }

    @Test(description = "数据中心-财务数据-筛选全部营收数据趋势图",dataProvider = "dataProvider")
    public void testGetCostTrend(String dateType,String metric,long endTime,long startTime){


        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,trend.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取财务数据-筛选全部营收数据趋势图失败");

    }

    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{

                {"WEEK","LEFT_AMOUNT","MEMBER_CARD",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,待消耗金额,会员卡
                {"WEEK","CONFIRMED_AMOUNT","EXPERIENCE_CARD",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,确认收入,体验卡
                {"WEEK","LEFT_AMOUNT","TRAINING_CAMP",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,待消耗金额,训练营
                {"WEEK","CONFIRMED_AMOUNT","DEPOSIT_CARD",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,确认收入,储值卡
                {"WEEK","LEFT_AMOUNT","SINGLE_RESERVE",TimeUtils.getWeekLastTime(),TimeUtils.getWeekFirstTime()},//本周,待消耗金额,单次约课

        };
    }

    @Test(description = "数据中心-财务数据-筛选本周的各种类型营收数据趋势图",dataProvider = "dataProvider1")
    public void testGetCostTrend(String dateType,String metric,String type,String endTime,String startTime){


        JSONObject trend=new JSONObject();
        trend.put("dateType",dateType);
        trend.put("endTime", endTime);
        trend.put("startTime", startTime);
        trend.put("metric",metric);
        trend.put("type",type);
        trend.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        trend.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        trend.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


        xmAppApi.doRequest(RequestType.JSON,params,trend.toJSONString(),headers).assetsSuccess(true);
        String trendResult=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(trendResult,"true","获取财务数据-筛选本周的各种类型营收数据趋势图失败");

    }

}
