package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestAddCustomizePrize extends XMBaseTest {
    @Resource(name = "luckyDrawTools")
    LuckyDrawTools luckyDrawTools;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_addCustomizePrize")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider
    public  Object[][] dataProvider(){
        return new Object[][]{
                {"自定义奖品",false},
                {"奖品"+ RandomStringUtil.randomString(5),true}
        };
    }
    @Test(description = "创建自定义奖品",dataProvider = "dataProvider")
    public void testAddCustomizePrize(String prizeName,boolean success){

        //获取当前自定义奖品列表数量
        int total = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getCustomizePrizeByPage(""),"$.result.total"));

        JSONObject body = new JSONObject();
        body.put("prizeName", prizeName);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers);
        if(success==false){
            Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"自定义奖品名称重复，请修改");
        }else{
            String prizeId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result");
            Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
            //检查自定奖品列表数据+1
            Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getCustomizePrizeByPage(""),"$.result.total"))==total+1);
            //清理数据
            luckyDrawTools.delCustomizePrize(prizeId);
        }
    }
}
