package com.xiaomai.cases.polar.finance.revenueAndExpenditure;


import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * @Author adu
 * @Description 传文件留到阿里云oss
 * @Date 13:13 2021-04-22
 */
public class ResourceUtil {
  public static final Logger logger = Logger.getLogger(ResourceUtil.class);


  public static final String OSS_ACCESS_KEY_ID = "OSSAccessKeyId";
  public static final String POLICY = "policy";
  public static final String SIGNATURE = "Signature";
  public static final String KEY = "key";
  public static final String SUCCESS_ACTION_STATUS = "success_action_status";
  public static final String FILE = "file";
  public static final String CALL_BACK = "callback";
  public static final String RESPONSE_STATUS = "200";
  public static final String CONTENT_TYPE = "multipart/form-data";

  /**
   * 上传文件留到阿里云oss
   *
   * @param inputStream 文件流
   * @param fileName 文件名称
   * @param signatureVO 临时访问阿里云授权签名
   * @return true 上传成功,false 失败
   * @throws IOException 关闭文件流或httpClient连接时可能会异常
   */
  public static boolean uploadFile(InputStream inputStream, String fileName,
      SignatureVO signatureVO, int timeout) throws IOException {
    CloseableHttpClient client = HttpClients.createDefault();

    RequestConfig requestConfig = RequestConfig.custom()
        //connectTimeout：指客户端和服务器建立连接的timeout，
        .setConnectTimeout(2000)
        //connectionRequestTimout：指从连接池获取连接的timeout
        .setConnectionRequestTimeout(2000)
        //socketTimeout：指客户端从服务器读取数据的timeout，超出后会抛出SocketTimeOutException,根据需要自定义
        .setSocketTimeout(timeout)
        .build();
    HttpPost post = new HttpPost(signatureVO.getHost());
    post.setConfig(requestConfig);
    BufferedReader br = null;
    try {

      // 参数顺序问题,该死的回调,千万要注意参数的顺序,死坑死坑
      MultipartEntityBuilder builder = MultipartEntityBuilder.create();
      builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);

      StringBody accessKeyId = new StringBody(signatureVO.getAccessId(),
          ContentType.MULTIPART_FORM_DATA);
      builder.addPart(OSS_ACCESS_KEY_ID, accessKeyId);

      StringBody policy = new StringBody(signatureVO.getPolicy(),
          ContentType.MULTIPART_FORM_DATA);
      builder.addPart(POLICY, policy);

      StringBody callBackStr = new StringBody(signatureVO.getCallback(),
          ContentType.MULTIPART_FORM_DATA);
      builder.addPart(CALL_BACK, callBackStr);

      StringBody signature = new StringBody(signatureVO.getSignature(),
          ContentType.MULTIPART_FORM_DATA);
      builder.addPart(SIGNATURE, signature);

      // 兼容key中的中文名称
      StringBody key = new StringBody(signatureVO.getKey(),
          ContentType.APPLICATION_JSON);
      builder.addPart(KEY, key);

      builder.addBinaryBody(FILE, inputStream, ContentType.create(CONTENT_TYPE), fileName);

      StringBody successActionStatus = new StringBody(RESPONSE_STATUS,
          ContentType.MULTIPART_FORM_DATA);
      builder.addPart(SUCCESS_ACTION_STATUS, successActionStatus);

      HttpEntity entity = builder.build();
      post.setEntity(entity);

      //发送请求
      HttpResponse response = client.execute(post);
      int status = response.getStatusLine().getStatusCode();
      if (Integer.valueOf(RESPONSE_STATUS).equals(status)) {
        return true;
      } else {
        entity = response.getEntity();
        if (entity != null) {
          inputStream = entity.getContent();
          br = new BufferedReader(new InputStreamReader(inputStream, Consts.UTF_8));
          StringBuilder message = new StringBuilder();
          String body;
          while ((body = br.readLine()) != null) {
            message.append(body);
          }
          logger.error("文件上传失败!message:{}"+message);
        }
        return true;
      }
    } catch (Exception e) {
      logger.error("文件上传异常!", e);
    } finally {
      if (br != null){
        br.close();
      }
      inputStream.close();
      client.close();
    }
    return false;
  }
}
