package com.xiaomai.cases.polar.entry;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/6 14:09
 */
public class TestScan extends XMBaseTest {
    EntryTool entryTool = new EntryTool();
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_scan")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "会员扫码入场")
    public void testScan(){
        JSONObject object = new JSONObject();
        object.put("memberId","1805435813468483586");
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.memberId"),"1805435813468483586");
        
        String id = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.id");
        Assert.assertEquals(entryTool.memberEntryPage("MEMBER").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id"),id);

        JSONObject res = entryTool.getMemberEntry(id).getJSONObject("result");
        Assert.assertEquals(res.getString("memberId"),"1805435813468483586");
        Assert.assertEquals(res.getString("entryType"),"MEMBER");
        Assert.assertEquals(res.getString("entryMethod"),"CODE");
        Assert.assertEquals(res.getString("entryVoucherType"),"VENUE_BOOKING");//原本是RESERVE，后面改成了 VENUE_BOOKING

    }
}
