package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/**
 * 删除课次（删除当前课次/删除当前及后续课次）
 *
 * @author adu
 * data 2024/6/30 17:02
 */

public class TestDelCurrentAndSubsequentGroupSchedule extends UniversalDataScheduling {

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_delGroupScheduleItem", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }


    @Test(description = "删除当前及后续课次")
    public void testDelCurrentAndSubsequentGroupSchedule() {
        //获取下周三的课次ID(匹配到对应的规则ID)
        String scheduleIdsG = groupScheduleTools.getTableDate(9, groupRuldId);
        //如果课次ID有值则继续走删除的case
        if (!StringUtils.isEmpty(scheduleIdsG)) {
            JSONObject body = new JSONObject();
            body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            body.put("applyRestRule", true);
            body.put("scheduleId", scheduleIdsG);
            xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"));


            //删除成功后check 从下周三到下周日课表是否有数据
            groupScheduleTools.getGroupScheduleTable(Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(9)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndDay()), courseId);
            Long countB = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").toJavaList(JSONObject.class).stream()
                    .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                    .filter(e -> null != e.getString("ruleId"))
                    .filter(e -> e.getString("ruleId").equals(groupRuldId)).count();
            Assert.assertTrue(countB == 0, "删除当前及后续课次后，课表中后端返回数据有问题，目前还能发现数据");


        }
    }

    @AfterTest(description = "删除此case创建的日程")
    public void delData() {
            if (!StringUtils.isEmpty(groupRuldId)) {//获取到的日程ID不为空时，则逐个删除相关日程
                //删除对应日程
                groupScheduleTools.delGroupRuleSchedule(groupRuldId, true);
            }
        }


    }




    