package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * 编辑训练营活动
 * 场景1：未发布的操作编辑
 * 场景2：报名中的操作编辑
 *
 * @author adu
 * data 2024/7/3 20:51
 */

public class TestEditNoPublishTraining extends BaseCreateTrainingData {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    String trainingId = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_editTraining", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "测试编辑未发布的训练营活动")
    public void testEditNoPublishTraining() {
        //1创建未发布的训练营活动
        String title = "杭州减肥训练营-未发布" + RandomStringUtil.randomString(3);
        trainingId = trainingTools.createTrainingNoPublish(title, courseId, trainerListIdS);
        //根据训练营活动名称全局搜索
        trainingTools.commonSearchTraining(title);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() > 0, "刚创建的活动没在全局搜索中发现哈");
        //编辑未发布的活动
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId()); // 场馆
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("applyEndTime", applyEndTime);//报名结束时间
        body.put("applyStartTime", applyStartTime);//报名开始时间
        body.put("courseId", courseId); //关联课程ID
        body.put("creatorId", xmAppApi.getLoginInfo().getAdminId()); // 创建人即操作者
        body.put("openEndDate", openEndDate1); //改了开营开始时间
        body.put("openStartDate", openStartDate1); //改了开营结束时间
        body.put("price", 0.09); //售卖价格
        body.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
        String editTitle = "杭州自动化测试训练营-未发布-编辑title" + RandomStringUtil.randomString(3);
        body.put("title", editTitle);
        body.put("totalClassHour", 1); // 总课次数
        body.put("traineeLowerLimit", 1); // 开营人数
        body.put("traineeUpperLimit", 10); // 人数上限
        body.put("trainerList", editTrainerListId); // 移除一个人
        body.put("xcxSaleStatus", "NO"); //开启改成关闭小程序售卖
        body.put("underlinePrice", 999); //划线价
        body.put("id", trainingId); //活动ID
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

        //查看训练营活动详情
        trainingTools.findTrainingDetailById(trainingId);
        String detailResult = dataApi.getApi_response();
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.title"), editTitle);
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.openStartDate"), openStartDate1);
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.xcxSaleStatus"), "NO");
        Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(detailResult, "$.result.underlinePrice")), 999.00);
        Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(detailResult, "$.result.price")), 0.09);
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.traineeLowerLimit"), "1");
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.traineeUpperLimit"), "10");
        Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.totalClassHour"), "1");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.trainerIds").size() == 1, "教练修改成1个人后，数据对不上");

    }




    @AfterTest(description = "删除此case创建的训练营")
    public void delData() {
        if (!trainingId.isEmpty()) {
            trainingTools.deleteTraining(trainingId);
        }

    }

}

