package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.reserve.personal
 * @Author: xuyamei
 * @CreateTime: 2024-07-24  15:32
 * @Description:批量设置特殊可约时间
 * @Version: 1.0
 */
public class TestCreateBatchSpecialDate extends BaseTestImpl {
    @Resource(name = "reserveTools")
    ReserveTools reserveTools;
    JSONArray coachIds = new JSONArray();

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Reserve,"API_createBatchSpecialDate", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test(description = "设置特定日期可约")
    public void testCreateBatchSpecialDate() {
        // 获取教练列表
        JSONObject pageStudioPersonalCoach = reserveTools.pageStudioPersonalCoach("");
        int total = pageStudioPersonalCoach.getInteger("total");
        Random rand = new Random();
        // 随机取两个教练
        String coachedId1 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");
        coachIds.add(coachedId1);
        String coachedId2 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");
        if (coachedId1.equals(coachedId2)){
            coachedId2 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?9:total-1)).getString("id");
        }
        coachIds.add(coachedId2);

        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());

        JSONObject specialTimeInfoRequest = new JSONObject();
        // 可约时间类型
        specialTimeInfoRequest.put("dutyType", "ON_DUTY");

        // 设置特定日期
        JSONArray selectedDates = new JSONArray();
        selectedDates.add(TimeUtils.getTodayTime());
        specialTimeInfoRequest.put("selectedDates", selectedDates);

        // 如果是可约时间非全天休息，则传可约时间段
        // 时间段 00:00 ~ 23:59
        JSONArray timePeriodInfos = new JSONArray();
        JSONObject timeInfo = new JSONObject();
        timeInfo.put("minuteOffset", 0);
        timeInfo.put("spanMinutes", 60);
        timePeriodInfos.add(timeInfo);
        specialTimeInfoRequest.put("timePeriodInfos", timePeriodInfos);
        body.put("specialTimeInfoRequest", specialTimeInfoRequest);
        body.put("coachIds", coachIds);
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // 批量设置特殊可约时间后检查个人私教时间是否有这条数据
        for (int j = 0; j < coachIds.size(); j++){
            JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(coachIds.getString(j), "specialTimeVOS");
            boolean flag = false;
            for (int i = 0; i < specialTimeVOS.size(); i++) {
                JSONObject specialTimeVO = specialTimeVOS.getJSONObject(i);
                if (selectedDates.getString(0).equals(specialTimeVO.getString("dutyDate"))) {
                    flag = true;
                    // 查询可约类型： 全天休息 -1, 可约时间 1,
                    Assert.assertEquals(specialTimeVO.getString("dutyType"), "1", "特殊日期类型错误");
                    // 查询这条数据的可约时间
                    Assert.assertTrue(specialTimeVO.getString("timePeriodInfos").equals(timePeriodInfos.toString()), "特殊日期可约时间段");

                }
            }
            Assert.assertTrue(flag, "批量设置特殊日期后没有找到相关数据");
        }

    }

    @Test(description = "删除特殊日期",priority = 1)
    public void testDeleteSpecialDate1() {
        for (int j = 0; j < coachIds.size(); j++){
            // 查询特殊可约时间列表
            JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(coachIds.getString(j),"specialTimeVOS");

            for (int i = 0; i < specialTimeVOS.size(); i++){
                String id = specialTimeVOS.getJSONObject(i).getJSONArray("recordIds").getString(0);
                // 删除查询到的特殊可约时间
                reserveTools.deleteSpecialDate(id);
            }

            specialTimeVOS = reserveTools.getPersonalCoachTime(coachIds.getString(j),"specialTimeVOS");
            Assert.assertEquals(specialTimeVOS.size(),0,"删除特殊日期后，特殊日期列表不为空");

        }

    }
    @Test(description = "设置特定日期全天休息",priority = 2)
    public void testCreateBatchSpecialDate2() {
        // 获取教练列表
        JSONObject pageStudioPersonalCoach = reserveTools.pageStudioPersonalCoach("");
        int total = pageStudioPersonalCoach.getInteger("total");
        Random rand = new Random();
        // 随机取两个教练
        String coachedId1 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");
        coachIds.add(coachedId1);
        String coachedId2 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?10:total)).getString("id");
        if (coachedId1.equals(coachedId2)){
            coachedId2 = pageStudioPersonalCoach.getJSONArray("records").getJSONObject(rand.nextInt(total>10?9:total-1)).getString("id");
        }
        coachIds.add(coachedId2);

        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId()); // 操作人id
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());

        JSONObject specialTimeInfoRequest = new JSONObject();
        // 可约时间类型
        specialTimeInfoRequest.put("dutyType", "OFF_DUTY");

        // 设置特定日期
        JSONArray selectedDates = new JSONArray();
        selectedDates.add(TimeUtils.getBeforeDayDate(-1)); // 第二天
        specialTimeInfoRequest.put("selectedDates", selectedDates);
        body.put("specialTimeInfoRequest", specialTimeInfoRequest);
        body.put("coachIds", coachIds);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // 批量设置特殊可约时间后检查个人私教时间是否有这条数据
        for (int j = 0; j < coachIds.size(); j++){
            JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(coachIds.getString(j), "specialTimeVOS");
            boolean flag = false;
            for (int i = 0; i < specialTimeVOS.size(); i++){
                JSONObject specialTimeVO = specialTimeVOS.getJSONObject(i);
                if (selectedDates.getString(0).equals(specialTimeVO.getString("dutyDate"))){
                    flag = true;
                    // 查询可约类型： 全天休息 -1, 可约时间 1,
                    Assert.assertEquals(specialTimeVO.getString("dutyType"),"-1","特殊日期类型错误");
                }
            }
            Assert.assertTrue(flag, "设置特殊日期全天休息后没有找到相关数据");
        }

    }

    @Test(description = "删除特殊日期",priority = 3)
    public void testDeleteSpecialDate() {
        for (int j = 0; j < coachIds.size(); j++){
            // 查询特殊可约时间列表
            JSONArray specialTimeVOS = reserveTools.getPersonalCoachTime(coachIds.getString(j),"specialTimeVOS");

            for (int i = 0; i < specialTimeVOS.size(); i++){
                String id = specialTimeVOS.getJSONObject(i).getJSONArray("recordIds").getString(0);
                // 删除查询到的特殊可约时间
                reserveTools.deleteSpecialDate(id);
            }

            specialTimeVOS = reserveTools.getPersonalCoachTime(coachIds.getString(j),"specialTimeVOS");
            Assert.assertEquals(specialTimeVOS.size(),0,"删除特殊日期后，特殊日期列表不为空");

        }

    }


}
