package com.xiaomai.cases.lunar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

public class GoodCTools extends XMBaseTest {

    /**
     * @param
     * @description:C端获取物品列表
     * @author: yff
     **/

    public JSONObject pageXcxHomeGoodsC(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_pageXcxHomeGoodsC")
                .setTerminal(Terminal.C);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("current", 0);
        jsonObject.put("size",20);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        JSONArray ids=new JSONArray();
        jsonObject.put("ids",ids);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:获取C端的物品详情
     * @param id：物品ID
     * @author: yff
     **/

    public JSONObject getDetail_goods_C(String id, DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_getDetail_goods_C")
                .setTerminal(Terminal.C);

        super.beforeDataRequest(userInfos);

        JSONObject jsonObject = new JSONObject();

        jsonObject.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,jsonObject.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @param
     * @description:拉取C端小程序物品组列表
     * @author: yff
     **/

    public JSONObject listXcxGoodsGroup(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Lunar_Goods)
                .setApiName("API_listXcxGoodsGroup")
                .setTerminal(Terminal.C);

        super.beforeDataRequest(userInfos);

        JSONObject listXcxGoodsGroup=new JSONObject();
        listXcxGoodsGroup.put("studioId",dataApi.getLoginInfo().getStudioId());
        JSONArray ids=new JSONArray();
        listXcxGoodsGroup.put("ids",ids);

        dataApi.doRequest(RequestType.JSON,dataparams,listXcxGoodsGroup.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

}
