package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestUpdateGetdetail extends XMBaseTest {

    Tools tools=new Tools();
    OrderTools orderTools=new OrderTools();
    CardTools cardTools=new CardTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_getDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "修改订单销售业绩-查看订单详情")
    public void testUpdateGetdetail(){

        String ownerId ="1796482784551211010";
        String ownerName="f昵称昵称昵称f昵称昵称昵称f昵称昵称昵";

        Tools tools=new Tools();
        String name = "退单手续费"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("111");
        String memberId = tools.create(name,phone).getString("result");

        JSONObject memberCard=orderTools.fetchPageOfMemberCard("次卡","MEMBER_CARD");
        String cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        BigDecimal quantity= new BigDecimal(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("benefitList").getJSONObject(0).getString("balance"));

        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));

        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        JSONObject orderResult= orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, 0, "PURCHASE",
                "MEMBER_CARD", memberId, price, price , "1", true);//会员签单
        String getDetailId = orderResult.getString("result");//获取刚创建的订单id

        orderTools.updateBusinessOwnerInfo(ownerId,ownerName,getDetailId,0.25,50);//修改业归属人

        orderTools.getDetail(getDetailId);//查看订单详情
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.businessOwners[0].ownerId"), ownerId, "修改订单业绩人错误");//断言业绩归属人
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.businessOwners[0].owner.name"), ownerName, "修改订单业绩人错误");

        //System.out.println("--------"+price);//--------1.0

        //退单，产生手续费

        orderTools.listUserRefundableCard("MEMBER","次卡",memberId);//查看会员名下可退卡
        String memberCardId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result[0].id");//拿新购买的卡ID

        JSONObject getDetailBResult=orderTools.getDetail(getDetailId);//查看订单详情
        BigDecimal quantity1= new BigDecimal(getDetailBResult.getJSONObject("result").getJSONArray("voucherItems").getJSONObject(0).getJSONObject("purchaseCardSkuAttr").getJSONArray("skuItemAttrs").getJSONObject(0).getString("quantity"));
        orderTools.refundOrder(ownerId,ownerName,0,memberCardId,quantity1,1,"MEMBER_CARD",memberId,0,0,"1",1,new BigDecimal(1),new BigDecimal(0));
        String getDetailId1=XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//退单订单id

        orderTools.getDetail(getDetailId1);//查看退单订单详情
        //Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.voucherItems[0].deductionAmount"), 1.0, "");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.voucherItems[0].deductionAmount"), "1.0000", "订单未产生手续费");//断言退单详情，手续费产生1元





    }



}
