package com.xiaomai.cases.polar.goods;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.goods.Tools.GoodTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class createGoodsGroup extends XMBaseTest {
    GoodTools goodTools=new GoodTools();

    String name1="自动化创建分组";
    String name2="自动化编辑分组";

    String createId;



    String groupId;

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Goods)
                .setApiName("API_createGoodsGroup")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "创建分组")
    public void testCreateGoodsGroup() {

        name1="自动化创建分组";

        //创建之前先看下列表的分组是不是10个，大于等于10就不走新建分组这个case了
        JSONObject listPageGoodsGroup=goodTools.listPageGoodsGroup();
        JSONArray listPageGoodsGroup_result=listPageGoodsGroup.getJSONArray("result");
        if(listPageGoodsGroup_result.size()<10){
            //创建之前先校验重名不重名
            Boolean checkNameRepeatGoodsGroup=Boolean.parseBoolean(goodTools.checkNameRepeatGoodsGroup(name1).getString("result"));
            if (checkNameRepeatGoodsGroup==false){
                //创建分组
                JSONObject createGoodsGroup=goodTools.createGoodsGroup(name1);
                groupId=createGoodsGroup.getString("result");

                //校验分组是否创建成功
                //校验1：B端分组列表中是否有这个分组
                JSONObject afterListPageGoodsGroup=goodTools.listPageGoodsGroup();
                JSONArray afterListPageGoodsGroup_result=afterListPageGoodsGroup.getJSONArray("result");

                boolean success=false;
                for(int i=0; i < afterListPageGoodsGroup_result.size(); i++){
                    if(afterListPageGoodsGroup_result.getJSONObject(i).getString("id").equals(groupId)){
                         success=true;
                    }
                    Assert.assertEquals(success,true,"新建分组成功，但是分组中未找到对应的分组ID");
                }

                //校验2：新建物品拉取分组名称的时候也有此条数据
                JSONObject listGoodsGroup=goodTools.listGoodsGroup();
                JSONArray listGoodsGroupResult=listGoodsGroup.getJSONArray("result");
                boolean success_listGoodsGroup=false;

                for(int i=0;i < listGoodsGroupResult.size();i++){
                    if(listGoodsGroupResult.getJSONObject(i).getString("id").equals(groupId)){
                         success_listGoodsGroup=true;
                    }
                    Assert.assertEquals(success_listGoodsGroup,true,"新建分组成功，但分组中未找到对应的分组ID");
                }

                //新建一个物品
                JSONObject create=goodTools.testCreateGoods_multiple("YES","0.01",10);
                createId=create.getString("result");

                //新建分组成功后，批量移动物品至其分组
                JSONObject jsonObject=goodTools.batchModifyGoodsBelongGroup(groupId,createId);

                //移动至其分组校验
                //校验1：该分组物品数量为1
                JSONObject afterListPageGoodsGroup_count=goodTools.listPageGoodsGroup();
                JSONArray afterListPageGoodsGroup_result_count=afterListPageGoodsGroup_count.getJSONArray("result");

                for(int i=0; i < afterListPageGoodsGroup_result_count.size(); i++){
                    if(afterListPageGoodsGroup_result_count.getJSONObject(i).getString("id").equals(groupId)){
                        String goodsCount=afterListPageGoodsGroup_result_count.getJSONObject(0).getString("goodsCount");
                        Assert.assertEquals(goodsCount,"1","批量移动1个数据至该分组之后，该分组下物品数不为1");
                    }
                }

                Boolean checkNameRepeatGoodsGroup_modify=Boolean.parseBoolean(goodTools.checkNameRepeatGoodsGroup(name2).getString("result"));

                if (checkNameRepeatGoodsGroup_modify==false) {
                   //编辑分组
                    JSONObject  modifyGoodsGroup=goodTools.modifyGoodsGroup(groupId,name2);

                    //编辑之后校验编辑是否成功
                    //校验1：分组列表中有这个修改后的分组名称
                    JSONObject afterListPageGoodsGroup_modify=goodTools.listPageGoodsGroup();
                    JSONArray afterListPageGoodsGroup_result_modify=afterListPageGoodsGroup_modify.getJSONArray("result");

                    boolean success_modify=false;
                    for(int i=0; i < afterListPageGoodsGroup_result_modify.size(); i++){
                        if(afterListPageGoodsGroup_result_modify.getJSONObject(i).getString("name").equals(name2)){
                            success_modify=true;
                        }
                        Assert.assertEquals(success_modify,true,"编辑分组成功，但列表中没有编辑成功后的分组");
                    }

                    //校验2：新建物品拉取分组名称的时候也有此条编辑后的数据
                    JSONObject listGoodsGroup_modify=goodTools.listGoodsGroup();
                    JSONArray listGoodsGroupResult_modify=listGoodsGroup_modify.getJSONArray("result");
                    boolean success_listGoodsGroup_modify=false;

                    for(int i=0;i < listGoodsGroupResult_modify.size();i++){
                        if(listGoodsGroupResult_modify.getJSONObject(i).getString("id").equals(groupId)){
                            success_listGoodsGroup_modify=true;
                        }
                        Assert.assertEquals(success_listGoodsGroup_modify,true,"编辑分组成功，但在新建物品时拉取分组未找到对应的分组ID");
                    }

                }
                else {
                    System.out.println("场馆已存在相同名称分组");
                }

            }
            else {
                System.out.println("场馆已存在相同名称分组");
            }

        }
        else{
            System.out.println("分组列表已经超过10个");
        }




    }

    @Test(description = "删除数据：物品和分组",priority = 1)
    public void testDeleteGoodsGroup() {

        //先删除物品
        JSONObject deleteGoods=goodTools.deleteGoods(createId);

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //再删除分组
        //先校验分组下有没有物品，没有物品才可以删除
        Boolean checkAllowDeleteSuccess=Boolean.parseBoolean(goodTools.checkAllowDelete(groupId).getJSONObject("result").getString("success"));

        if(checkAllowDeleteSuccess==true) {

            JSONObject deleteGoodsGroup = goodTools.deleteGoodsGroup(groupId);
            //删除分组校验
            //校验1：分组列表中没有这个物品
            JSONObject afterListPageGoodsGroup=goodTools.listPageGoodsGroup();
            JSONArray afterListPageGoodsGroup_result=afterListPageGoodsGroup.getJSONArray("result");

            boolean success=false;
            for(int i=0; i < afterListPageGoodsGroup_result.size(); i++){
                if( ! afterListPageGoodsGroup_result.getJSONObject(i).getString("id").equals(groupId)){
                    success=true;
                }
                Assert.assertEquals(success,true,"删除分组成功，但列表中还有此条数据");
            }

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //校验2：新建物品拉取分组名称的时候没有此条编辑后的数据
            JSONObject listGoodsGroup=goodTools.listGoodsGroup();
            JSONArray listGoodsGroupResult=listGoodsGroup.getJSONArray("result");
            boolean success_listGoodsGroup=false;

            for(int i=0;i < listGoodsGroupResult.size();i++){
                if( ! listGoodsGroupResult.getJSONObject(i).getString("id").equals(groupId)){
                    success_listGoodsGroup=true;
                }
                Assert.assertEquals(success_listGoodsGroup,true,"删除分组成功，但在新建物品时拉取分组还有此条数据");
            }

        }
        else {
            System.out.println("该分组下有物品，不可删除");
        }
    }
    }
