package com.xiaomai.cases.polar.points;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.coupon.CouponTools;
import com.xiaomai.cases.polar.export.ExportTool;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestFindAccountPagePermission extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Points)
                .setApiName("API_findAccountPagePermission")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Resource(name = "pointsTools")
    PointsTools pointsTools;

    @Resource(name = "tools")
    Tools tools;

    @Resource(name = "trainingTools")
    TrainingTools trainingTools;


    @Test(description = "场馆手动-积分")
    public void testFindAccountPagePermission(){
        String phone = "13357537209";
        String memberId = trainingTools.searchTargerMember(phone);
        if (memberId.isEmpty()) {
            memberId = tools.create("杨剑积分", phone).getString("result");
        }

        //获取场馆初始会员的发放积分数、已使用积分数、剩余积分数
        int BetotalAwardBalance = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].totalAwardBalance"));//发放积分数
        int BealreadyUsedBalance = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].alreadyUsedBalance"));//已用积分数
        int BeleftBalance = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].leftBalance"));//剩余积分数
        System.out.println("betotal--------"+BetotalAwardBalance);
        System.out.println("beuse--------"+BealreadyUsedBalance);
        System.out.println("beleft--------"+BeleftBalance);

        int before = Integer.parseInt(XMJSONPath.readPath(pointsTools.findStatementPagePermission(xmAppApi.getLoginInfo().getStudioId()), "$.result.total"));//积分记录列表总条数
        System.out.println("before--------"+before);


        pointsTools.manualAwardPoint("1",memberId);//会员详情增加1积分
        //核对积分帐户的积分的变化
        int AftotalAwardBalance1 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].totalAwardBalance"));//发放积分数
        int AfleftBalance1 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].leftBalance"));//剩余积分数
        System.out.println("aftotal1--------"+AftotalAwardBalance1);
        System.out.println("afleft1--------"+AfleftBalance1);
        Assert.assertEquals(AftotalAwardBalance1,BetotalAwardBalance+1);//断言发放积分数+1
        Assert.assertEquals(AfleftBalance1,BeleftBalance+1);//断言剩余积分数+1
        //核对积分记录
        int after1 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findStatementPagePermission(xmAppApi.getLoginInfo().getStudioId()), "$.result.total"));
        System.out.println("after1--------"+after1);
        Assert.assertEquals(after1,before+1);//断言积分记录+1条记录
        String str = Integer.toString(AfleftBalance1);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "IN_MANUAL_GIVE", "第一条记录非手动增加记录");//断言列表第一条手动增加积分的记录
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].accountLeftBalance"), str, "积分记录明细中，剩余积分和积分帐户对不上");//断言积分记录中的剩余积分


        pointsTools.manualDeductPoint("1",memberId);//会员详情扣减1积分
        //核对积分帐户的积分的变化
        int AfalreadyUsedBalance2 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].alreadyUsedBalance"));//已使用积分积分数
        int AfleftBalance2 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findAccountPagePermission(xmAppApi.getLoginInfo().getStudioId(),memberId), "$.result.records[0].leftBalance"));//剩余积分数
        System.out.println("aftuse2--------"+AfalreadyUsedBalance2);
        System.out.println("afleft2--------"+AfleftBalance2);
        Assert.assertEquals(AfalreadyUsedBalance2,BealreadyUsedBalance+1);//断言已使用积分数+1
        Assert.assertEquals(AfleftBalance2,AfleftBalance1-1);//断言剩余积分数-1
        //核对积分记录
        int after2 = Integer.parseInt(XMJSONPath.readPath(pointsTools.findStatementPagePermission(xmAppApi.getLoginInfo().getStudioId()), "$.result.total"));
        System.out.println("after2--------"+after2);
        Assert.assertEquals(after2,after1+1);//断言积分记录+1条记录
        String str1 = Integer.toString(AfleftBalance2);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "OUT_MANUAL_DEDUCT", "第一条记录非手动扣减记录");//断言列表第一条手动扣减积分的记录
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].accountLeftBalance"), str1, "积分记录明细中，剩余积分和积分帐户对不上");//断言积分记录中的剩余积分

    }
}
