package com.xiaomai.cases.polar.brandMerchant;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestCheckUnbind extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Merchant)
                .setApiName("API_checkUnbind")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    /**
     * 乐动收银-修改记录会有此接口请求
     */
    @Test(description = "检验未绑定状态")
    public void testCheckUnbind() {

        JSONObject object = new JSONObject();
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, object.toJSONString(), headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response, "$.message"), "操作成功!");
    }

}
