package com.xiaomai.cases.polar.config;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author: xyy
 * @CreateTime: 2024-06-12  11:48
 * @Description:短信充值失败
 * @Version: 1.0
 */
public class TestGetSmsRechargeOrderStatus extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Config)
                .setApiName("API_getSmsRechargeOrderStatus")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "短信充值失败")
    public void testGetSmsRechargeOrderStatus(){

        //随机生成订单id
        String orderId = RandomStringUtil.randomNumber(3,"");

        JSONObject object = new JSONObject();
        object.put("orderId",orderId);
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(false);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"充值订单不存在");
    }
}


