package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * 删除训练营课次（单个/当前及后续）
 * @author adu
 * data 2024/7/12 17:05
 */

public class TestDelCampScheduleItem extends SelectTargetTrainingCampAndGetInfo{
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;
    String campId = "";
    String chiefCoachId = "";
    String ruldId = "";
    int loopNum=0;
    String[] weekDaysArray = {"TUESDAY", "THURSDAY", "SATURDAY", "SUNDAY"};
    List<String> weekdaysList = Arrays.asList(weekDaysArray);

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_delCampScheduleItem", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
        // 获取选择的训练营ID
        campId = super.campId;
        //1.2获取训练营活动的指定教练ID
        chiefCoachId = super.chiefCoachId;
        //获取目标时间段内 最大有效课时数
        loopNum = campScheduleTools.queryExpectedLoopNum(CommUtil.oneKeyGetAddDay(3), super.openEndDate, weekdaysList);

        //创建训练营排课：按次数 星期：2，4，6，7
        campScheduleTools.oneKeyCreateCampRuleSchedule(campId, chiefCoachId, super.courseId,
                super.traineeLowerLimit, super.traineeUpperLimit,
                "1140", super.openEndDate, true,
                String.valueOf(loopNum));
        //查询排课日程:根据训练营和关联课程查询
        campScheduleTools.getCampRuleScheduleList(campId, super.courseId, "");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 1, "排课创建成功后，日程中没查询到对应数据");
        ruldId = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").getJSONObject(0).getString("ruleId");
    }
    @Test(description = "删除当前课次")
    public void testDelCurrentCampScheduleItem(){
        //获取下周日课次ID
        Set<String> scheduleIds7 = campScheduleTools.getCampTableDate(13);
        if(scheduleIds7.size() != 0 && scheduleIds7 != null){
            //删除下周日所有的课次
            scheduleIds7.stream().forEach(scheduleId -> {
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("applyRestRule", false);
                body.put("scheduleId", scheduleId);
                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
            });

            //删除成功后check 下周日课表是否有数据
            String startDate = CommUtil.oneKeyGetNextWeekXDay(13);//下周日00点时间
            String endDate = CommUtil.oneKeyGetNextWeekEndXDay(7);//下周日23：59
            campScheduleTools.getCampScheduleTable(startDate,endDate);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.totalCount"), "0");
        }

    }

    @Test(description = "删除当前及后续课次", priority = 1)
    public void testDelCurrentAndSubsequentCampSchedule() {
        //获取下周六课次ID
        Set<String> scheduleIds6 = campScheduleTools.getCampTableDate(12);
        if(scheduleIds6.size() != 0 && scheduleIds6 != null){
            //删除下周日所有的课次
            scheduleIds6.stream().forEach(scheduleId -> {
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("applyRestRule", true);
                body.put("scheduleId", scheduleId);
                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
            });

            //删除成功后check从下周六到排课结束日期课表是否有数据
            String startDate = CommUtil.oneKeyGetNextWeekXDay(12);//下周六00点时间
            campScheduleTools.getCampScheduleTable(startDate, super.openEndDate);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.totalCount"), "0");

            //删除成功后，check对应训练营活动的已排课次数是否同步变更
            int delLoopNum=campScheduleTools.queryExpectedLoopNum(startDate, super.openEndDate, weekdaysList);
            //查看日程，获取原规则中展示的训练营已排课课次数,原来已排课课次数-删除的已排课课次数
            campScheduleTools.getCampRuleScheduleDetail(ruldId);
            Assert.assertTrue(XMJSONPath.getJSONObjectByReadPath(dataApi.getApi_response(),"$.result.campVO").getIntValue("scheduleClassHour")==(loopNum-delLoopNum));

        }

    }

    @AfterTest(description = "删除此case创建的训练营排课日程")
    public void delData() {
        //先删除规则，再操作删除对应的训练营活动，此处顺序不能换，如果先删除训练营活动，对应的排课会自动删除，所以就不用删除排课日程了，这个场景其他case中会体现
        if (null!=ruldId||!ruldId.isEmpty()) {
            campScheduleTools.delCampRuleSchedule(ruldId);
            //删除日程后check 日程列表数据是否还能搜索到，期望搜索结果数据为空
            campScheduleTools.getCampRuleScheduleList(campId,super.courseId,"");
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 0, "日程被删除后，对应的排课日程列表还可以查到相关数据");
        }

        if (null!=campId||!campId.isEmpty()) {
            this.getTrainingTools().deleteTraining(campId);
        }

    }
}

    