package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  17:21
 * @Description: 获取合同编辑展示页-首次创建
 * @Version: 1.0
 */
public class TestGetContractEditDisplay extends BaseTestImpl {
    @Resource(name = "eleContractTools")
    EleContractTools eleContractTools;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getContractEditDisplay", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }


    @Test
    public void testGetContractEditDisplay(){
        // 查询指定的模版
        String templateId = eleContractTools.getNormalTemplateList("自动化").getJSONObject(0).getString("id");
        JSONObject body = new JSONObject();
        body.put("adminId",xmAppApi.getLoginInfo().getAdminId());
        body.put("templateId",templateId);
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

        JSONObject response = xmAppApi.getBodyInJSON().getJSONObject("result");
        JSONArray contractPdfVOList = response.getJSONArray("contractPdfVOList");

        for (int i = 0; i < contractPdfVOList.getJSONObject(0).getJSONArray("contractFieldVOList").size(); i++){
            if (contractPdfVOList.getJSONObject(0).getJSONArray("contractFieldVOList").getJSONObject(i).getString("templateField").equals("COMPANY_NAME")){
                // 验证返回的公司名称
                Assert.assertTrue(contractPdfVOList.getJSONObject(0).getJSONArray("contractFieldVOList").getJSONObject(i).getString("value").equals("杭州牧歌供应链管理有限公司"));
            }else if (contractPdfVOList.getJSONObject(0).getJSONArray("contractFieldVOList").getJSONObject(i).getString("templateField").equals("TENANT_NAME")){
                // 验证返回的场馆名称
                Assert.assertTrue(contractPdfVOList.getJSONObject(0).getJSONArray("contractFieldVOList").getJSONObject(i).getString("value").equals("小小瑜伽城西银泰西湖场馆"));
            }
        }
        Assert.assertTrue(response.getJSONObject("templateVO").getJSONArray("fieldConfigVOList").size()>=6,"模版字段数量大于等于6");
    }

}
