package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;

public class TestCheckBeforeRefund extends XMBaseTest {

    CashierTools cashierTools=new CashierTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkBeforeRefund")
                .setLoginUser(LoginAccount.YFF_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "乐动收银退款预校验-检查流水是否可退")
    public void testCheckBeforeRefund(){


        //获取交易记录（流水）列表-收款成功流水
        JSONObject result=cashierTools.page_sift("WX","SIGN_ORDER","PAY_SUCCESS");
        int total=Integer.parseInt(result.getJSONObject("result").getString("total"));

        if(total>0) {
            String signId=result.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");//流水ID
            BigDecimal actualAmount=new BigDecimal(result.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("actualAmount"));


            JSONObject jsonObject=new JSONObject();

            JSONArray ids=new JSONArray();
            ids.add(signId);
            jsonObject.put("ids",ids);

            jsonObject.put("amount",actualAmount);
            jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());


            xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
            String success=xmAppApi.getBodyInJSON().getString("success");
            Assert.assertEquals(success,"true","乐动收银退款预校验-检查流水是否可退失败");
            System.out.println("检查流水结果："+xmAppApi.getBodyInJSON().getJSONObject("result").getString("code"));//检查结果
        }

    }

}
