package com.xiaomai.cases.polar.coupon;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 小麦乐动优惠券工具类
 *
 * @author adu
 * data 2024/7/25 17:32
 */
@Component("couponTools")
public class CouponTools extends BaseTestImpl {

    /**
     * 同一个ApiModule下的登录信息封装出一个类，减少代码冗余
     *
     * @param apiName
     * @param userInfo
     */
    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Polar_Coupon)
                .setApiName(apiName)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);
    }

    /**
     * 创建优惠券
     *
     * @param useThresholdType      使用门槛：1无门槛 WITHOUT 2达到条件可用 THRESHOLD
     * @param receiveTimesUpperType 每人领取次数限制：1每人限领 FIXED 2不限制 WITHOUT
     * @param memberStatusLimits    可领取会员类型 ["POTENTIAL", "NORMAL", "HISTORY"] 一共3种，可以自己自定义选其中的某个或者全部
     * @param couponName            优惠券的名称
     * @param allScope              适用范围 全部：true，非全部：false
     * @param preferentialType      优惠方式：1金额 CERTAIN 2折扣 DISCOUNT
     * @param quantity              发放数量
     * @param validPeriodType       使用有效期方式：1固定期限 ABSOLUTE  2领取后生效 RELATIVE
     * @param memo                  备注
     * @return 优惠券ID
     */
    public String createCoupon(String useThresholdType, String receiveTimesUpperType, List<String> memberStatusLimits, String couponName,
                               Boolean allScope, String preferentialType, int quantity, String validPeriodType, String memo) {

        setUP("API_createCoupon");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        JSONObject receiveCondition = new JSONObject();
        body.put("useThresholdType", useThresholdType);
        if (useThresholdType.equals("THRESHOLD")) {//使用门槛是达到条件可用
            body.put("useThreshold", 10);//目前没写成动态传参，固定为10元
        }
        receiveCondition.put("receiveTimesUpperType", receiveTimesUpperType);
        if (receiveTimesUpperType.equals("FIXED")) {
            receiveCondition.put("receiveTimesUpper", 1);//每人限领次数
        }
        receiveCondition.put("memberStatusLimits", memberStatusLimits);//可领取会员类型
        body.put("receiveCondition", receiveCondition);
        body.put("name", couponName);
        body.put("allScope", allScope);
        if (allScope.equals(false)) {//适用范围不是选全部时
            List<String> scope = new ArrayList<>();
            scope.add("TRAINING_CAMP");
            body.put("scope", scope);//此处固定写了适用范围为训练营
        }
        body.put("preferentialType", preferentialType);

        if (preferentialType.equals("CERTAIN")) {//优惠方式选择金额
            body.put("preferential", 10);
        }
        if (preferentialType.equals("DISCOUNT")) {//优惠方式选择金额
            body.put("preferential", 8.8);
        }

        body.put("quantity", quantity);
        body.put("validPeriodType", validPeriodType);
        if (validPeriodType.equals("RELATIVE")) {//有效期：领取后生效
            body.put("relativeDay", 1); //使用有效期：领取后 1天内
          /*  body.put("validPeriodStartTime", "");
            body.put("validPeriodEndTime","");*/
        }
        if (validPeriodType.equals("ABSOLUTE")) {//有效期：固定时间
            body.put("validPeriodStartTime", CommUtil.oneKeyGetAddDay(1));//有效期的开始时间:明天的0点
            body.put("validPeriodEndTime", CommUtil.getNDayEndTimeTamp(5));//有效期的结束时间：5天后的 23：59：59
        }
        if (null != memo || !memo.isEmpty()) {
            body.put("memo", memo);
        }

        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

    }
}

    