package com.xiaomai.cases.lunar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.util.ArrayList;
import java.util.List;

public class ResevervePersonalTools extends XMBaseTest {
    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Lunar_Reserve)
                .setApiName(apiName)
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfo);
    }
    /**
     * @description:查询小程序私教课教练
     * @author: yj
     * @date:  2024/8/14 16:34
     * @param memberId
     * @param scheduleStartTime
     * @param scheduleEndTime
     * @param scheduleEndTime
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getEnablePersonalCoachList(String memberId, Long scheduleStartTime,String coachId, Long scheduleEndTime){
        setUP("API_getEnablePersonalCoachList");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("startDate", scheduleStartTime);
        jsonObject.put("endDate",scheduleEndTime);
        jsonObject.put("courseChooseEnum","ALL");
        jsonObject.put("memberId",memberId);//会员ID
        jsonObject.put("coachId",coachId);//教练ID
        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:小程序-获取教练下的私教课
     * @author: yj
     * @date:  2024/8/14 16:34
     * @param coachId 教练ID
     * @param courseType 课程类型
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getCourseByPage(String coachId,String courseType){
        setUP("API_getCourseByPage");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("coachId",coachId);//教练ID
        jsonObject.put("courseType",courseType);//课程类型：PERSONAL 私教
        jsonObject.put("current",0);
        jsonObject.put("size",5);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:小程序-获取私教课的预约规则
     * @author: yj
     * @date:  2024/8/14 16:34

     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject personalBookingRules(){
        setUP("API_personalBookingRules");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:查看小程序预约私教课页面的可预定时间
     * @author: yj
     * @date:  2024/8/14 16:34

     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getPersonalTimeBlocks(String coachId, String courseId,String selectedDate){
        setUP("API_getPersonalTimeBlocks");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("coachId", coachId);
        jsonObject.put("courseId", courseId);
        jsonObject.put("selectedDate", selectedDate);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:查看小程序，私教课的预约记录
     * @author: yj
     * @date:  2024/8/14 16:34

     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getPageByMemberbype(String signInStateSet1, String memberId,String scheduleStartDate,String scheduleEndDate){
        setUP("API_getPageByMember");

        List signInStateSet = new ArrayList();
        signInStateSet.add(signInStateSet1);//预约状态


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("signInStateSet", signInStateSet);
        jsonObject.put("size", 10);
        jsonObject.put("memberId", memberId);
        jsonObject.put("scheduleStartDate", scheduleStartDate);
        jsonObject.put("scheduleEndDate", scheduleEndDate);
        jsonObject.put("courseType", "PERSONAL");//课程类型私教


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:查看私教课的预约详情
     * @author: yj
     * @date:  2024/8/14 16:34

     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getDetailByIdbype(String reserveId){
        setUP("API_getDetailById");




        JSONObject jsonObject = new JSONObject();
        jsonObject.put("reserveId", reserveId);



        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * @description:小程序私教课的取消约课
     * @author: xuyamei
     * @date:  2024/6/26 10:32
     * @param reserveId 预约id
     * @param memberId 会员id
     * @param success 正常传true
     * @return: void
     **/
    public void cancelMemberReservebype(String reserveId, String memberId, boolean success) {
        setUP("API_cancelMemberReserve");

        JSONArray reserveIds = new JSONArray();
        reserveIds.add(reserveId);
        JSONObject body = new JSONObject();
        body.put("reserveIds",reserveIds);
        body.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(success);
    }

    /**
     * @description:小程序预约私教课
     * @author: xuyamei
     * @date:  2024/6/26 10:32
     * @return: void
     **/
    public JSONObject addPersonal(String areaIds1,String benefitId,String chiefCoachId,String courseId,String memberId,String planCheckBalance,String reserveMemberNum,String scheduleStartTime,String spanMinutes) {
        setUP("API_addPersonal");

        JSONArray areaIds = new JSONArray();
        areaIds.add(areaIds1);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("areaIds",areaIds);
        jsonObject.put("benefitId",benefitId);
        jsonObject.put("chiefCoachId",chiefCoachId);
        jsonObject.put("courseId",courseId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("memo","自动化约私教课");
        jsonObject.put("planCheckBalance",planCheckBalance);
        jsonObject.put("reserveMemberNum",reserveMemberNum);
        jsonObject.put("scheduleStartTime",scheduleStartTime);
        jsonObject.put("spanMinutes",spanMinutes);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }



}
