package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-02-29  14:04
 * @Description: 检验员工是否存在
 * @Version: 1.0
 */
public class TestCheckExistInStudio extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;

    @BeforeMethod
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Admin,"API_checkExistInStudio", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {true,"","手机号存在但是返回的是false"},
                {false,"99900900000","手机号不存在返回的true"},
        };
    }
    @Test(dataProvider = "dataProvider")
    public void testCheckExistInStudio(boolean flag,String phone, String message){
        if (flag){
            phone = xmAppApi.getLoginInfo().getAccountNo();
        }
        JSONObject response = adminTools.checkExistInStudio(phone);
        boolean result = response.getBoolean("result");
        Assert.assertEquals(result,flag,message);

    }
}
