package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-04-19  15:55
 * @Description: 校验角色名称是否重复
 * @Version: 1.0
 */
public class TestCheckRoleNameDup extends BaseTestImpl {

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_checkRoleNameDup", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
                {"店长",true},
                {"店长24843585",false}

        };
    }
    @Test(dataProvider = "data")
    public void testCheckRoleNameDup(String name,boolean flag){
        String body = "{\"roleName\": \""+name+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(Boolean.parseBoolean(response.getString("result")),flag,"校验角色名称是否重复");

    }
}
