package com.xiaomai.cases.polar.finance.revenueAndExpenditure;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSumNormalIncomeExpense extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumNormalIncomeExpense")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"INCOME","SIGN"},//收入，签单
                {"EXPENSE","REFUND"}//支出，退单
        };
    }

    @Test(description = "获取统计收支",dataProvider = "dataProvider")
    public void testSumNormalIncomeExpense(String type,String item){


        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add("1");
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"true","获取统计收支失败");
    }
}
