package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestMemberCardSuspend extends XMBaseTest {
    @Resource(name = "cardTools")
    CardTools cardTools;

    public String memberCardId = "";
    public String memberCardState;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_membercard_suspend")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @DataProvider
    public  Object[][] dataProvider(){
        return new Object[][]{
                {"MEMBER"},//会员卡
                {"DEPOSIT"},//储值卡
                {"EXPERIENCE"}//体验卡
        };
    }
    @Test(description = "停用已售卡",dataProvider = "dataProvider")
    public void testMemberCardSuspend(String cardType) {
        //查询生效中的卡列表
        cardTools.memberCardSearch(cardType,"NORMAL");
        //先检查列表有没有数据，有数据才会执行下面的点代码（如果是个空机构，肯定不会被执行，想从存量数据中获取，需要自己先造个数据）
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            //取出第一个数据后，要check下会员卡的启用状态，想停用，要保证卡的状态目前就是启用状态
            memberCardState=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].state");
            //如果不是启用状态，则开启
            if(memberCardState.equals("SUSPEND")){
                cardTools.memberCardCancelSuspend(memberCardId);
            }

            //获取该卡的变动记录条数
            int num = Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.total"));

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("planRestoreDate", TimeUtils.getAfterDayDate(1));//恢复使用时间
            jsonObject.put("memberCardId", memberCardId);
            jsonObject.put("memo","自动化停卡");
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());

            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

            //check 会员卡详情，查看状态是否是已停用状态
            Assert.assertEquals(XMJSONPath.readPath(cardTools.memberCardFindDetailById(memberCardId),"$.result.state"),"SUSPEND");

            //check 变动记录新增1条数据
            Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.total"))==num+1);
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.records[0].operateType").equals("SUSPEND_CARD"),"操作停卡，变动记录第一条操作类型");
            Assert.assertTrue(XMJSONPath.readPath(cardTools.fetchPageOfOperateRecord(memberCardId),"$.result.records[0].remark").equals("自动化停卡"),"操作停卡，变动记录第一条的备注");
        }
    }
}
