package com.xiaomai.cases.polar.entry;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/5 17:16
 */
public class EntryTool extends XMBaseTest {

    public JSONObject entryRuleList(){
        dataApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_memberEntryRuleList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        List codeList = new ArrayList();
        codeList.add("MEMBER_CARD_ENTRY");
        codeList.add("MEMBER_CARD_REPEAT_ENTRY");
        codeList.add("EXPERIENCE_CARD_ENTRY");
        codeList.add("EXPERIENCE_CARD_REPEAT_ENTRY");
        codeList.add("RESERVE_ENTRY");
        codeList.add("RESERVE_ENTRY_TIME_LIMIT");
        codeList.add("RESERVE_ENTRY_LAG_MINUTES");
        codeList.add("RESERVE_ENTRY_LEAD_MINUTES");

        JSONObject object = new JSONObject();
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("codeList",codeList);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }

    //入场记录列表
    public JSONObject memberEntryPage(String entryType){
        dataApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_memberEntryPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject object = new JSONObject();
        object.put("entryType",entryType);
        object.put("startTime", TimeUtils.getTodayTime());
        object.put("endTime",TimeUtils.getTodayEndTime(30));
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("size",20);
        object.put("current",0);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }

    //入场记录详情
    public JSONObject getMemberEntry(String id){
        dataApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_getMemberEntry")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject object = new JSONObject();
        object.put("id",id);
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }

    //计算扣次额度
    public JSONObject calQuantity(String entryVoucherId,String entryVoucherType,String memberId){
        dataApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_calQuantity")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject object = new JSONObject();
        object.put("entryVoucherId",entryVoucherId);
        object.put("entryVoucherType",entryVoucherType);
        object.put("memberId",memberId);
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }

    //入场的卡凭证列表
    public JSONObject listUserVenueEntryCard(String accountType,String memberId){
        dataApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_listUserVenueEntryCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        List memberCardStateList = new ArrayList();
        memberCardStateList.add("UN_ACTIVE");
        memberCardStateList.add("NORMAL");

        JSONObject object = new JSONObject();
        object.put("accountType",accountType);
        object.put("memberId",memberId);
        object.put("memberCardStateList",memberCardStateList);
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }
    //添加入场记录
    public JSONObject addmemberEntry(String entryVoucherType,String entryVoucherId,String memberId){
        dataApi.setApiModule(ApiModule.Polar_MemberEntry)
                .setApiName("API_manual")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject object = new JSONObject();
        object.put("entryVoucherType",entryVoucherType);//EXPERIENCE_CARD 体验卡
        object.put("memberId",memberId);
        object.put("entryVoucherId",entryVoucherId);
        object.put("remark","自动化脚本手动添加入场记录备注");
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();

    }
}
