package com.xiaomai.cases.polar.points;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.goods.GoodCTools;
import com.xiaomai.cases.lunar.reserve.ReserveCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.eventRegistration.EventRegistrationTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.cases.polar.setting.venue.VenueAreaTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.*;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TestPointsMini extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Points)
                .setApiName("API_memberPoint_getAccount")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "pointsMinTools")
    PointsMInTools pointsMinTools;

    GoodCTools goodCTools=new GoodCTools();

    OrderTools orderTools = new OrderTools();

    DataUserInfo info = new DataUserInfo();

    @Resource(name = "EventRegistrationTools")
    EventRegistrationTools EventRegistrationTools;

    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;

    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;

    @Resource(name = "courseTools")
    CourseTools courseTools;

    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;

    @Resource(name = "reserveCTools")
    ReserveCTools reserveCTools;

    @Test(description = "小程序-积分")
    public void testmemberPoint_getAccount() throws InterruptedException {
        String memberId = userTools.getMemberInfo().getString("memberId");

        //pointsMinTools.memberPoint_getAccount(memberId);
        int BeleftBalance = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员在小程序初始积分数
        System.out.println("BeleftBalance--------"+BeleftBalance);

        goodCTools.purchaseGoods("0.00",null,memberId,"物品积分自动化","100.00","1938148913966530562", BigDecimal.valueOf(100),1);//C端下单不支付
        String id =XMJSONPath.readPath(dataApi.getApi_response(), "$.result.id");

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);//切换B端
        orderTools.pay(BigDecimal.valueOf(100),"1",id,info);//B端支付
        Thread.sleep(1000);
        int AfleftBalance = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员购买物品后，剩余积分数
        Assert.assertEquals(AfleftBalance,BeleftBalance+10);//断言剩余积分数+10

        pointsMinTools.findStatementPage(memberId, String.valueOf(true));
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].initialBalance"), "10", "第一条非加10积分的记录");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "IN_ORDER_CONSUME", "第一条非物品的积分记录");

        //作废订单
        orderTools.discard(id,"订单录错","",info);//B端
        Thread.sleep(1000);
        int AfleftBalance1 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员购买物品后，剩余积分数
        Assert.assertEquals(AfleftBalance1,AfleftBalance-10);//断言剩余积分数+10

        pointsMinTools.findStatementPage(memberId, String.valueOf(false));
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].initialBalance"), "-10", "第一条非减去10积分的记录");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].transactionType"), "OUT_ORDER_REFUND", "第一条退购买物品的积分记录");

        //活动报名
        String activityName = "积分参与" + RandomStringUtil.randomString(5);
        EventRegistrationTools.create(activityName,true, TimeUtils.getTodayTime(),TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),TimeUtils.getToDayTime(23,00),info);//创建并发布活动
        String activityId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result");

        EventRegistrationTools.MinsellableActivity_getStudioActivityById(activityId);//查看活动详情

        String activitySkuId= XMJSONPath.readPath(dataApi.getApi_response(),"$.result.skuItems[1].id");//获取活动购买项目id
        EventRegistrationTools.purchaseSellableActivity(activityId, String.valueOf(100),activitySkuId,memberId);//报名
        String id1 =XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//订单ID
        System.out.println("id1--------"+id1);
        orderTools.pay(BigDecimal.valueOf(100),"1",id1,info);//B端支付
        Thread.sleep(1000);
        int AfleftBalance2 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员购买物品后，剩余积分数
        Assert.assertEquals(AfleftBalance2,AfleftBalance1+10);//断言剩余积分数+10

        //作废订单
        orderTools.discard(id1,"订单录错","",info);//B端
        Thread.sleep(1000);
        int AfleftBalance3 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员退物品后，剩余积分数
        Assert.assertEquals(AfleftBalance3,AfleftBalance2-10);//断言剩余积分数-10

        //单次约课 白写
        //String todayStartTimeTamp = CommUtil.oneKeyGetAddDay(1);
        //String todayEndDateTimeTamp = CommUtil.getNDayEndTimeTamp(1);
        //String categoryId = courseCategoryTools.getCourseCategoryPage("积分");
        //String courseId = courseTools.getPersonalOrGroupCourseId("GROUP", "储值卡付费约课积分课程", categoryId, "STUDIO", "", 2, 1).getString(0);
        //int[] minuteOffset = {60, 120, 180,  240, 300, 360,  420,  480, 540,  600,  660, 720, 780,  840,  900, 960, 1020, 1080, 1140, 1200, 1260};
        //Random random = new Random();
        //1.1-创建排课日程（当前天的课程）
        //groupScheduleTools.createGroupRuleSchedule(courseId, "1800447404349558786", todayStartTimeTamp, todayEndDateTimeTamp, new ArrayList(), new ArrayList(), true, 1,minuteOffset[random.nextInt(20)] ,info);
        //List<String> chiefCoachId = new ArrayList<>();
        //chiefCoachId.add("1800447404349558786");

        //JSONArray result = groupScheduleTools.getGroupRuleScheduleList(courseId, "1800447404349558786");
        //String ruldId = XMJSONPath.readPath(result.getJSONObject(0), "$.ruleId");
        // 日程列表中新增一条刚创建的规则，匹配到对应的ruldId
        //Long goalRuld = result.toJavaList(JSONObject.class).stream().filter(e -> e.getString("ruleId").equals(ruldId)).count();
        //Assert.assertTrue(goalRuld == 1);
        //查看今天的课表，获取刚创建的日程中对应的课次ID
        //groupScheduleTools.getGroupScheduleTable(Long.valueOf(todayStartTimeTamp),Long.valueOf(todayEndDateTimeTamp),courseId,info);
        //reserveCTools.memberTimetable(memberId,TimeUtils.getBeforeDayDate(-1), TimeUtils.getAfterDayDate(1));
        //JSONArray array = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups");
        //String scheduleId = array.toJavaList(JSONObject.class).stream()
                //.flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                //.filter(e -> null != e.getString("ruleId"))
                //.filter(e ->e.getString("ruleId").equals(ruldId))
                //.map(e -> e.getString("scheduleId"))//获取scheduleId
                //.findFirst().orElse(null);

        //JSONObject getScheduleItemDetail = groupScheduleTools.getScheduleItemDetail(scheduleId);
        //long startTime1 = getScheduleItemDetail.getLongValue("startTime");
        //System.out.println("scheduleId--------"+scheduleId);
        //System.out.println("startTime1--------"+startTime1);

        //String voucherId = reserveCTools.createSingleReserve1(false,courseId,"1800447404349558786",memberId,scheduleId,startTime1,10,0,"1938194478934331393","100.00");

        //场地预约
        //String startMinute = String.valueOf((TimeUtils.hourOfDay()+1)*60);
        //String endMinute = String.valueOf((TimeUtils.hourOfDay()+1)*60+30);//结束时间与开始时间相差30分钟
        //String reserveDay = String.valueOf(TimeUtils.getTodayTime());
        //String groupId ="1938174465507115009";
        //String areaId = String.valueOf(Long.valueOf(groupId)+1);//+1,不知道为啥
        //String voucherId = venueAreaTools.purchaseAreaTimes1(startMinute,endMinute,BigDecimal.valueOf(100),"1929736213382733826",groupId,memberId,"0.00",reserveDay,areaId,"100.00","1938194478934331393");
        //String venueBookingRecordId = XMJSONPath.readPath(venueAreaTools.getByVoucher(voucherId,info),"$.result.id");//场地预约的记录id
        //Thread.sleep(1000);
        //断言场地预约积分增加10分
        //int AfleftBalance4 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员退物品后，剩余积分数
        //Assert.assertEquals(AfleftBalance4,AfleftBalance3+10);//断言剩余积分数+10

        //venueAreaTools.manualCheckIn(venueBookingRecordId);//场地签到
        //Thread.sleep(1000);
        //断言场地预约签到增加10分
        //int AfleftBalance5 = Integer.parseInt(XMJSONPath.readPath(pointsMinTools.memberPoint_getAccount(memberId), "$.result.leftBalance"));//会员退物品后，剩余积分数
        //Assert.assertEquals(AfleftBalance5,AfleftBalance4+10);//断言剩余积分数+10





    }

}
