package com.xiaomai.cases.lunar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.reserve.ReserveCTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestAddPersonal extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Reserve)
                .setApiName("API_addPersonal")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "使用会员卡约私教课")
    public void testaddPersonal() {

        UserTools userTools = new UserTools();
        String memberId = userTools.getMemberInfo().getString("memberId");

        ResevervePersonalTools resevervePersonalTools =new ResevervePersonalTools();

        String coachId="1796482517508263938";//固定教练杨剑-杨老师教练
        resevervePersonalTools.getCourseByPage(coachId,"PERSONAL");
        String courseId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].brandCourseId");//拿教练的第一个私教课程

        ReserveCTools reserveCTools =new ReserveCTools();
        String todayStartTimeTamp = CommUtil.oneKeyGetAddDay(1);
        String scheduleEndTime = CommUtil.oneKeyGetAddDay(1);
        reserveCTools.listUserReservableBenefit(courseId,"PERSONAL","MEMBER",memberId,Long.parseLong(todayStartTimeTamp));
        String benefitId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result[0].benefitId");//拿教练的第一个私教课程

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("benefitId",benefitId);
        jsonObject.put("chiefCoachId",coachId);//教练ID
        jsonObject.put("courseId",courseId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("memo","自动化小程序约私教课");
        jsonObject.put("planCheckBalance",1);
        jsonObject.put("reserveMemberNum",1);
        jsonObject.put("scheduleStartTime",Long.valueOf(todayStartTimeTamp));//预约0点到0点10分的私教课
        jsonObject.put("spanMinutes",10);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

        JSONObject response = xmAppApi.getBodyInJSON();
        String reserveId = XMJSONPath.readPath(response, "$.result.reserveId");//预约成功后，拿预约记录id

        resevervePersonalTools.getPageByMemberbype("UN_SIGNED",memberId,todayStartTimeTamp,scheduleEndTime);
        Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].id"),reserveId,"预约记录状态异常");//查看第一条是否为正常约课的私教课记录

        resevervePersonalTools.cancelMemberReservebype(reserveId,memberId,true);//取消预约的私教课

        resevervePersonalTools.getDetailByIdbype(reserveId);
        Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.courseType"),"PERSONAL","非私教课类型");
        Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.reserveState"),"RESERVE_CANCEL","未取消约课");




    }
}
