package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.training.TrainingTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestGetStudioMemberPrizeByPage extends XMBaseTest {
    @Resource(name = "luckyDrawTools")
    LuckyDrawTools luckyDrawTools;
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    DataUserInfo info = new DataUserInfo();
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_getStudioMemberPrizeByPage")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();

    }
    @Test(description = "幸运抽奖-会员中奖列表")
    public void testGetStudioMemberPrizeByPage(){
        //获取会员信息
        String memberId = trainingTools.searchTargerMember("自动化会员");;
        //调用请求
        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",10);
        body.put("memberId",memberId);
        body.put("prizeType","CUSTOMIZE_GIFT");
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
        //若该会员名下有抽奖记录，则进入手动兑奖流程：
        int total = Integer.parseInt(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.total"));
        if (total>0){
            for (int i = 0; i < total-1; i++) {
                String sendState = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.records["+i+"].sendState");
                String sendRecordId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.records["+i+"].id");
                String activityId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.records["+i+"].activityId");
                //获取到的兑奖记录，暂未兑奖，可进行兑奖：
                if(sendState=="NOT_SENT"){
                    Assert.assertEquals(luckyDrawTools.exchangePrize(sendRecordId),"$.message","操作成功!");
                    //兑奖状态=已兑换
                    Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getLuckyAttendByPage(activityId),"$.result.records[0].sendState"),"SENT");//已兑奖状态
                    break;
                }else{
                    //该兑奖记录若已兑奖，则提示兑奖码已兑换！
                    Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.exchangePrize(sendRecordId),"$.message"),"该奖品码已兑换");
                }
            }
        }
    }
}
