package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestFindDetailById extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findDetailById")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取会员详情以及更多资料")
    public void testFindDetailById(){

        //暂时还不能转会员，只能写死：memberId：1771002119284924417-自动化正式会员勿动

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("memberId","1771002119284924417");

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"true","获取会员详情以及更多资料失败");

    }
    @Test(description = "获取会员详情以及更多资料-会员id不能为空")
    public void testFindDetailById_1(){

        JSONObject jsonObject1=new JSONObject();
        jsonObject1.put("memberId","");

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject1.toJSONString(),headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$message"),"会员id不能为空");

    }
}
