package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 16:03
 */
@Component("memberTools")
public class MemberTools extends BaseTestImpl {

    //创建潜在会员
    public JSONObject create(String name,String phone,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_create")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        Random random = new Random();
        String[] idCardType = {"IDENTITY","SAR_PERMIT","PASSPORT"};//身份证、港澳通行证、护照
        String[] intention = {"HIGH","MIDDLE","LOW"};//意向度：高、中、低

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("creatorId",dataApi.getLoginInfo().getAdminId());
        object.put("status","POTENTIAL");
        object.put("name",name);
        object.put("phone",phone);
        object.put("gender","UNKNOWN");
        object.put("wechat","12345678");
        object.put("birthday","1277654400000");
        object.put("idCardType",idCardType[random.nextInt(3)]);
        object.put("idCardCode", RandomStringUtil.randomNumber(18,"410526"));
        object.put("height","180");
        object.put("weight","66");
        object.put("trainTarget","减脂");
        object.put("profession","无");
        object.put("incomeLevel","66666/月");
        object.put("address","同人广场a座小麦助教");
        object.put("emergencyContactPerson","紧急联系人名字");
        object.put("emergencyContactPhone","15896688889");
        object.put("intention",intention[random.nextInt(3)]);
        object.put("position","INITIAL");
        object.put("remark","这是备注");
        object.put("saleId","-1");

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //是否存在相同手机号
    public JSONObject checkPhoneDuplicate(String phone,String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_checkPhoneDuplicate")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("phone",phone);
        object.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //会员详情
    public JSONObject findStudioMemberDetail(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findStudioMemberDetail")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("memberId",memberId);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //会员详情
    public JSONObject getDetailById(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findDetailById")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //搜索潜在会员
    public JSONObject searchMember(String position,String status,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_searchMember")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();

        List statusList = new ArrayList();
        statusList.add(status);

        switch (position){
            case "全部线索":
                object.put("searchType","CLUE_ALL");//全部线索
                break;
            case "我的线索":
                object.put("searchType","CLUE_PRIVATE");//我的线索
                object.put("position","PRIVATE_RESOURCE");
                object.put("saleId",dataApi.getLoginInfo().getAdminId());
                break;
            case "公有池":
                object.put("searchType","CLUE_PUBLIC");//公有池
                object.put("position","PUBLIC_RESOURCE");
                break;
            case "回收站":
                object.put("searchType","CLUE_RECYCLE");//回收站
                object.put("position","RECYCLE");
                break;
        }
        object.put("current",0);
        object.put("size",20);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("statusList",statusList);


        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    //搜索全部会员
    public JSONObject commonSearch(String content,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_commonSearch")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        List statusList = new ArrayList();
        statusList.add("NORMAL");
        statusList.add("HISTORY");
        statusList.add("POTENTIAL");

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("dataPermissionFilter",false);
        object.put("content",content);
        object.put("statusList",statusList);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //线索来源
    public JSONArray findByObjectId(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findByObjectId")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);
        List categories = new ArrayList();
        categories.add("RESOURCE");

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("categories",categories);
        object.put("objectId","1760544120783314946");

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }
    //全部线索快捷筛选
    public JSONObject fetchQuickSearch(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_fetchQuickSearch")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //我的线索快捷筛选
    public JSONObject fetchMyQuickSearch(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_fetchMyQuickSearch")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //在另一个场馆中添加同品牌下已存在的会员
    public JSONObject join(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_join")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //查询销售&教练列表
    public JSONObject fetchStaff(String role,List memberStatusList,String searchContext,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_fetchStaff")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("memberStatusList",memberStatusList);
        object.put("searchContext",searchContext);
        object.put("current",0);
        object.put("size",20);
        object.put("role",role);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //分配线索至公有池
    public JSONObject distributeToPublic(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_distributeToPublic")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        List memberIds =  new ArrayList();
        memberIds.add(memberId);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("memberIds",memberIds);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //分配线索至私有池
    public JSONObject distributeToPrivate(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_distributeToPrivate")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        List memberIds =  new ArrayList();
        memberIds.add(memberId);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("saleId",dataApi.getLoginInfo().getAdminId());
        object.put("memberIds",memberIds);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //将线索移至回收站
    public JSONObject disable(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_disable")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        List memberIds =  new ArrayList();
        memberIds.add(memberId);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("reason","自动化脚本移至回收站");
        object.put("memberIds",memberIds);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //查询场馆销售规则
    public JSONObject fetchCrmContext(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_fetchCrmContext")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //查询跟进
    public JSONObject searchFeedback(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_searchFeedback")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("memberId",memberId);
        object.put("current",0);
        object.put("size",10);
        object.put("state","DONE");

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //查询会员跟进任务（未开始或已逾期的；不分页，只支持单会员查询）
    public JSONObject listTodoTask(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_listTodoTask")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //删除跟进
    public JSONObject deleteFeedback(String feedbackId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_deleteFeedback")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("feedbackId",feedbackId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //添加跟进记录
    public JSONObject createFeedback(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_createFeedback")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        Random random = new Random();
        String[] feedbackMethod = {"PHONE","WECHAT","SMS","VISIT","OTHERS"};
        String[] feedbackResult = {"CONTACTED","INTENTION_CONFIRMED","APPOINTED","EXPERIENCED","REGISTERED","REGISTERED","RENEW_FOLLOW"};

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("feedbackContent","自动化测试添加跟进记录");
        object.put("feedbackMethod",feedbackMethod[random.nextInt(5)]);
        object.put("feedbackResult",feedbackResult[random.nextInt(7)]);
        object.put("memberId",memberId);
        object.put("nextFeedbackRemark","自动化测试下次跟进内容");
        object.put("nextFeedbackTime", TimeUtils.getTodayEndTime(1));

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //查看跟进详情
    public JSONObject findDetailById(String id,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findDetailByIdFeedback")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //统计今日待跟进&已逾期的任务数
    public JSONObject summaryFeedback(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_summaryFeedback")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
