package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  13:55
 * @Description: 电子合同工具类
 * @Version: 1.0
 */
@Component("eleContractTools")
public class EleContractTools extends XMBaseTest  {
    public void setUp(String name, DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_EleContract)
                .setApiName(name)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);
    }

    /**
     * @description: 查询电子合同模版列表
     * @author: xuyamei
     * @date:  2024/8/5 14:38
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getNormalTemplateList(String name) {
       setUp("API_getNormalTemplateList");
       String body = "{\"tenantId\":\""+dataApi.getLoginInfo().getStudioId()+"\",\"name\": \""+name+"\"}";
       dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
       return dataApi.getBodyInJSON().getJSONArray("result");
    }

    /**
     * @description:获取充值单列表
     * @author: xuyamei
     * @date:  2024/8/5 15:14
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getBalanceList(){
        setUp("API_getBalanceList");
        JSONObject body = new JSONObject();
        body.put("tenantId",dataApi.getLoginInfo().getStudioId());
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }

    public JSONArray getValidBalanceList(){
        setUp("API_getValidBalanceList");
        JSONObject body = new JSONObject();
        body.put("tenantId",dataApi.getLoginInfo().getStudioId());
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }



    /**
     * @description: 获取租户的预警配置
     * @author: xuyamei
     * @date:  2024/8/5 15:20
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getBalanceWarning(){
        setUp("API_getBalanceWarning");
        JSONObject body = new JSONObject();
        body.put("tenantId",dataApi.getLoginInfo().getStudioId());
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:获取合同编辑展示页-首次创建
     * @author: xuyamei
     * @date:  2024/8/5 17:49
     * @param templateId :合同模版id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getContractEditDisplay(String templateId){
        setUp("API_getContractEditDisplay");
        JSONObject body = new JSONObject();
        body.put("templateId",templateId);
        body.put("adminId",dataApi.getLoginInfo().getAdminId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }


    /**
     * @description:获取发起合同任务的状态
     * @author: xuyamei
     * @date:  2024/8/5 18:52
     * @param id :合同id
     * @return: boolean
     **/
    public boolean getStartContractV2Result(String id){
        setUp("API_getStartContractV2Result");

        String body = "{\"id\":\""+id+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getBoolean("result");
    }


    /**
     * @description:获取合同列表
     * @author: xuyamei
     * @date:  2024/8/5 19:14
     * @param targetId : 学员id
     * @param associatedId ：订单id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getContractPage(String targetId,String associatedId,String status){
        setUp("API_getContractPage");

        JSONObject body = new JSONObject();
        body.put("targetId",targetId);
        body.put("associatedId",associatedId);
        body.put("size",10);
        body.put("current",0);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        if (!status.equals("")){
            JSONArray statusList = new JSONArray();
            statusList.add(status);
            body.put("statusList",statusList);
        }

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");


    }

    /**
     * @description:撤回合同
     * @author: xuyamei
     * @date:  2024/8/6 10:40
     * @param contractId
     * @return: void
     **/
    public void retractContract(String contractId){
        setUp("API_retractContract");

        JSONObject body = new JSONObject();
        body.put("id",contractId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }


    public JSONObject getContract(String contractId){
        setUp("API_getContract");

        JSONObject body = new JSONObject();
        body.put("id",contractId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }


    /**
     * @description: 电子合同关联订单
     * @author: xuyamei
     * @date:  2024/8/6 15:02
     * @param contractId ：合同id
     * @param associatedNo ：订单号
     * @param associatedId  订单id
     * @return: void
     **/
    public void associate(String contractId,String associatedNo,String associatedId){
        setUp("API_associate");

        JSONObject body = new JSONObject();
        body.put("contractId",contractId);
        body.put("associatedNo",associatedNo);
        body.put("associatedId",associatedId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }

    /**
     * @description:合同取消关联订单
     * @author: xuyamei
     * @date:  2024/8/6 15:47
     * @param contractId 合同id
     * @return: void
     **/
    public void disAssociate(String contractId){
        setUp("API_disAssociate");

        JSONObject body = new JSONObject();
        body.put("id",contractId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }

    public void setBalanceWarning(int balanceWarning,String id){
        setUp("API_setBalanceWarning");

        JSONObject body = new JSONObject();
        body.put("warnAmount",balanceWarning);
        body.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        body.put("notifyPhone","13120057004");
        body.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }

    /**
     * @description 复制签署地址
     * @author: xuyamei
     * @date:  2024/8/6 16:58
     * @param id：合同id
     * @return: java.lang.String
     **/
    public String getContractSignUrl(String id){
        setUp("API_getContractSignUrl");

        JSONObject body = new JSONObject();
        body.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        body.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }



    /**
     * @description: 重新认证前置校验-存在待家长签署，签署中的合同都不允许重新认证
     * @author: xuyamei
     * @date:  2024/8/6 17:08
     * @return: boolean
     **/
    public boolean checkBeforeResetVerify(){
        setUp("API_checkBeforeResetVerify");
        String body = "{\"tenantId\":\""+dataApi.getLoginInfo().getStudioId()+"\"}";
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getBoolean("result");
    }





}
