package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  16:23
 * @Description: 校验租户合同配置
 * @Version: 1.0
 */
public class TestCheckContractConfig  extends BaseTestImpl {

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_checkContractConfig", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testCheckContractConfig(){
        JSONObject body = new JSONObject();
        body.put("tenantId",xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        body.put("checkAll", true);
        String[] types = {"VERIFY_RESULT","COMPANY_SIGNATURE","HAS_LEFT"};
        body.put("checkTypes", types);

        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON().getJSONObject("result");
        Assert.assertFalse(response.getBoolean("checkPass"));
        String[] checkTypes = {"VERIFY_RESULT","COMPANY_SIGNATURE","HAS_LEFT"};
        for (int i = 0; i < checkTypes.length; i++){
            Assert.assertTrue(response.getJSONObject("checkFailResult").getBoolean(checkTypes[i]));
        }
    }



}
