package com.xiaomai.cases.polar.setting.courseCategory;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.courseCategory
 * @Author: xuyamei
 * @CreateTime: 2024-04-29  09:40
 * @Description: 课程分类工具类
 * @Version: 1.0
 */
@Component("courseCategoryTools")
public class CourseCategoryTools extends XMBaseTest {


    /**
     * @description: 获取课程分类列表
     * @author: xuyamei
     * @date:  2024/4/29 08:08
     * @param current
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getCourseCategoryDetailPage(int current){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_courseCategory_getDetailPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("current",current);
        body.put("size",10);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * @description:获取存量的课程分类
     * @author: xuyamei
     * @date:  2024/5/6 11:32
     * @param categoryName ：新建的课程类型名称
     * @return: java.lang.String
     **/
    public String getCourseCategoryPage(String categoryName){
        // 获取存量的课程分类，列表数据存在则取第二条数据
        JSONObject detailPage = getCourseCategoryDetailPage(0);
        if (Integer.parseInt(detailPage.getJSONObject("result").getString("total"))>1){
            return detailPage.getJSONObject("result").getJSONArray("records").getJSONObject(1).getString("id");
        }
        // 没有则创建
        if (!checkCategoryNameDup(categoryName,"")){
            return createCourseCategory(categoryName);
        }
        return null;
    }

    /**
     * @description:校验课程分类名称重复
     * @author: xuyamei
     * @date:  2024/4/29 18:55
     * @param
     * @return: java.lang.String
     **/
    public boolean checkCategoryNameDup(String categoryName,String oldCategoryId){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_checkCategoryNameDup")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("categoryName",categoryName);
        if (oldCategoryId.equals("")){
            body.put("oldCategoryId",oldCategoryId);
        }
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs);
        return dataApi.getBodyInJSON().getBoolean("result");

    }


    /**
     * @description:创建课程分类
     * @author: xuyamei
     * @date:  2024/4/29 19:16
     * @param categoryName
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public String createCourseCategory(String categoryName){

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_createCourseCategory")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("categoryName",categoryName);
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs);
        return dataApi.getBodyInJSON().getJSONObject("result").getString("id");

    }

    /**
     * @description:删除课程分类
     * @author: xuyamei
     * @date:  2024/4/29 19:35
     * @param categoryId
     * @return: void
     **/
    public void deleteCourseCategory(String categoryId){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_deleteCourseCategory")
                .setTerminal(Terminal.B);

        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("categoryId",categoryId);
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
    }

    /**
     * @description:校验课程分类是否可编辑/删除
     * @author: xuyamei
     * @date:  2024/4/29 19:40
     * @param categoryId ：课程分类名称
     * @param del：是否编辑操作
     * @return:
     **/
    public boolean canModifyCourseCategory(String categoryId,boolean del){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_canModifyCourseCategory")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("categoryId",categoryId);
        body.put("del",del);
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs);
        return dataApi.getBodyInJSON().getBoolean("result");
    }

}
