package com.xiaomai.cases.polar.setting.pay;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

public class PayTools extends XMBaseTest {
    /**
     * @param
     * @description:获取通用配置-支付配置列表
     * @author: yangfangfang
     **/
    public JSONObject getList(DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("tenantId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]

        JSONArray categories=new JSONArray();
        categories.add("PAYMENT");
        jsonObject.put("categories",categories);//"会员来源", "支付方式" ]属性类别[ RESOURCE, PAYMENT ]

        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:新建通用配置-支付方式
     * @param name：支付方式名
     * @author: yangfangfang
     **/
    public JSONObject save(String name, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_save")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("category","PAYMENT");
        jsonObject.put("name",name);
        jsonObject.put("tenantId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:修改通用配置-支付方式(开启/关闭)
     * @param id：属性ID 支付方式id
     * @param name：属性名称 支付方式名称
     * @param status：[ "启用", "禁用", "删除" ]状态[ ON, OFF, DEL ]
     * @author: yangfangfang
     **/
    public JSONObject update(String id,String name, String status,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_update")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("name",name);
        jsonObject.put("tenantId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]
        jsonObject.put("status",status);
        jsonObject.put("category","PAYMENT");
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:删除通用配置-支付方式
     * @param ids：属性ID 支付方式id
     * @author: yangfangfang
     **/
    public JSONObject remove(String ids, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_remove")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();

        JSONArray jsonArray=new JSONArray();
        jsonArray.add(ids);
        jsonObject.put("ids",jsonArray);

        jsonObject.put("tenantId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]
        jsonObject.put("category","PAYMENT");
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:校验该支付方式是否使用过
     * @param id：支付方式id
     * @param paymentWay：支付方式code
     * @author: yangfangfang
     **/
    public JSONObject checkPaymentWayUsed(String id, String paymentWay,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkPaymentWayUsed")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("paymentWay",paymentWay);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

}
