package com.xiaomai.cases.polar.setting.venue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.venue
 * @Author: xuyamei
 * @CreateTime: 2024-05-08  11:26
 * @Description: 场地工具类
 * @Version: 1.0
 */
@Component("venueAreaTools")
public class VenueAreaTools extends XMBaseTest {

    /**
     * @description:创建场地
     * @author: xuyamei
     * @date:  2024/5/8 13:55
     * @param areaName：场地名称
     * @return: java.lang.String
     **/
    public String createVenueArea(String areaName) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_createVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body = new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        body.put("groupName",areaName);
        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    public void deleteVenueArea(String groupId) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_deleteVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("groupId",groupId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
    }

    /**
     * @description:查看场地列表数据
     * @author: xuyamei
     * @date:  2024/5/8 13:58
     * @return: ：返回列表数据
     **/
    public JSONObject getVenueAreaPage() {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("current",0);
        body.put("size",20);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }


    /**
     * @description:编辑场地
     * @author: xuyamei
     * @date:  2024/5/8 14:14
     * @param groupId ：场地id
     * @param groupName ：场地名称
     * @return: void
     **/
    public void editVenueAreaPage(String groupId,String groupName) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_editVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("groupName",groupName);
        body.put("groupId",groupId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
    }


    /**
     * @description:根据课程id获取场地详情
     * @author: xuyamei
     * @date:  2024/5/8 14:14
     * @param courseId ：课程id
     * @return:
     **/
    public JSONObject getListByStudioCourseId(String courseId){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getListByStudioCourseId")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("brandCourseId",courseId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");

    }

}
