package com.xiaomai.cases.polar.studio;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

public class TestEditStudioExt extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Studio)
                .setApiName("API_editStudioExt")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "编辑场馆信息")
    public void testeditStudioExt() {

        JSONObject address = new JSONObject();
        address.put("address", "同人广场自动化编辑场馆信息");
        address.put("province", 330000);
        address.put("city", 330100);
        address.put("distinct", 330106);
        address.put("fullAddress", "浙江省杭州市西湖区同人广场自动化编辑场馆信息");

        JSONObject announcement = new JSONObject();
        announcement.put("announcementSwitch", "VALID");
        announcement.put("content", "场馆公告自动化");


        List dayOfWeeks = new ArrayList();
        dayOfWeeks.add(1);
        dayOfWeeks.add(2);
        dayOfWeeks.add(3);
        dayOfWeeks.add(4);
        dayOfWeeks.add(5);
        dayOfWeeks.add(6);
        dayOfWeeks.add(7);

        JSONObject Object = new JSONObject();
        Object.put("dayOfWeeks", dayOfWeeks);
        Object.put("startMinute", 0);
        Object.put("endMinute", 1439);


        List businessTimes = new ArrayList();
        businessTimes.add(Object);

        List phones = new ArrayList();
        phones.add("12312312312");

        List services = new ArrayList();
        services.add("自动化设施");

        //List images = new ArrayList();
        //images.add("");



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("address",address);
        jsonObject.put("announcement",announcement);
        jsonObject.put("businessTimes",businessTimes);
        jsonObject.put("phones",phones);
        jsonObject.put("services",services);
        //jsonObject.put("images",images);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$code"),"200");

    }
}
