package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @author adu
 * data 2024/8/1 09:45
 */

public class TestEditPublishTraining extends BaseCreateTrainingData{
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    String oneKeytTrainingId = "";

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_editTraining", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "编辑已发布训练营活动")
    public void editPublishTraining() throws InterruptedException {
        //1.查询关联对应课程的活动数据
        trainingTools.searchTrainingList(courseId, "", new ArrayList<>());
        int listCountBefore = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        //2.创建已发布的训练营活动,报名开始时间晚于当前时间半小时
        oneKeytTrainingId = trainingTools.oneKeyCreateTraining(courseId, trainerListIdS, CommUtil.getTodayGoalTime(30));
        Thread.sleep(2000);
        //3.列表搜索数据check
        trainingTools.searchTrainingList(courseId, "", new ArrayList<>());
        Long list = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream()
                .filter(object -> object.getString("id").equals(oneKeytTrainingId)).count();
        Assert.assertTrue(list == 1, "训练营活动创建成功列表数据没增加");

        JSONObject goalObject = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream()
                .filter(object -> object.getString("id").equals(oneKeytTrainingId)).findFirst().orElse(null);//返回第一个对象，没有就返回空
        if (goalObject != null) {
            String title = goalObject.getString("title");
            String applyEndTime = goalObject.getString("applyEndTime");
            String applyStartTime = goalObject.getString("applyStartTime");
            String openStartDate = goalObject.getString("openStartDate");
            String openEndDate = goalObject.getString("openEndDate");
            //4.编辑已发布的活动（训练营名称，关联课程，开营时间，总课次数，售价，报名开始时间，报名结束时间不能修改）check不能修改的传值后也不会改变
            JSONObject editBody = new JSONObject();
            editBody.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            editBody.put("studioId", xmAppApi.getLoginInfo().getStudioId()); // 场馆
            editBody.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            editBody.put("applyEndTime", applyEndTime);//报名结束时间
            editBody.put("applyStartTime", applyStartTime);//报名开始时间
            editBody.put("courseId", courseId); //关联课程ID
            editBody.put("creatorId", xmAppApi.getLoginInfo().getAdminId()); // 创建人即操作者
            editBody.put("openEndDate", openEndDate); //开营结束时间
            editBody.put("openStartDate", openStartDate); //开营开始时间
            editBody.put("price", 10); //售卖价格
            editBody.put("surfaceUrl", "https://xiaomai-res.oss-cn-hangzhou.aliyuncs.com/xmfit/course_cover/training_camp_0.png"); // 默认活动封面图
            editBody.put("title", "title");//名称不能修改，这里故意修改了，等保存后check数据
            editBody.put("totalClassHour", 20); // 总课时数，不能修改，这里故意修改了，等保存后check数据
            editBody.put("traineeLowerLimit", 1); // 开营人数
            editBody.put("traineeUpperLimit", 99); // 人数上限
            editBody.put("trainerList", trainerListIdS); // 上课教练
            editBody.put("xcxSaleStatus", "YES"); //开启小程序售卖
            editBody.put("underlinePrice", 29.9);//可以修改
            editBody.put("id", oneKeytTrainingId); //活动ID
            xmAppApi.doRequest(RequestType.JSON, params, editBody.toString(), headers);
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));

            //5.查看活动详情，check 不能修改项和一修改项是否被同步修改
            trainingTools.findTrainingDetailById(oneKeytTrainingId);
            //5.1不能修改的字段check（修改后和修改前比对）
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.title"), title);
            Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.totalClassHour"), "2");
            Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.price")), 0.00);
            //5.2可以修改字段check是否被同步修改
            Assert.assertEquals(Double.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.underlinePrice")), 29.90);

        }


    }

    @AfterTest(description = "删除此case创建的训练营")
    public void delData() {
        if (!oneKeytTrainingId.isEmpty()) {
            trainingTools.deleteTraining(oneKeytTrainingId);
        }

    }
}

    