package com.xiaomai.cases.polar.setting.tag;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.admin.AdminTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


public class TestDeleteById extends XMBaseTest {

    TagTools tagTools=new TagTools();
    AdminTools adminTools=new AdminTools();


    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_deleteById")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "删除标签--未被会员使用")
    public void testDeleteById(){

        //获取当前标签列表
        JSONObject fetchPage=tagTools.tagFetchPage("");
        int total= Integer.parseInt(fetchPage.getJSONObject("result").getString("total"));

        //添加标签
        JSONObject createTag=tagTools.tagCreate("自动化"+ RandomStringUtil.randomString(3));
        String tagId=createTag.getString("result");

        //删除标签
        JSONObject deleteTag=new JSONObject();
        deleteTag.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        deleteTag.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        deleteTag.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        deleteTag.put("id",tagId);
        deleteTag.put("confirm","");

        xmAppApi.doRequest(RequestType.JSON,params,deleteTag.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String result=response.getJSONObject("result").getString("success");
        Assert.assertEquals(result,"true","删除标签失败");

        //获取当前标签列表
        JSONObject fetchPage2=tagTools.tagFetchPage("");
        int total2= Integer.parseInt(fetchPage2.getJSONObject("result").getString("total"));
        Assert.assertEquals(total2,total,"删除标签失败");

    }
    @Test(description = "删除标签--已被本场馆会员使用-同步删除同场馆会员的标签")
    public void testDeleteById_1(){

        //memberId：1801136353800269825-自动化标签会员勿动1（还不能删除线索，不添加这么多，暂时先用一个）

        //增加标签
        JSONObject createTag=tagTools.tagCreate("自动化标签勿动1");
        String tagId1=createTag.getString("result");

        //获取当前员工昵称
        JSONObject adminResult= adminTools.getStudioAdmin(xmAppApi.getLoginInfo().getAdminId());
        String  nickName=adminResult.getJSONObject("result").getString("nickName");

        //给会员添加标签
        JSONObject forceUpdate=tagTools.forceUpdate("1801136353800269825","自动化标签会员勿动1",nickName,"10022233333","POTENTIAL",tagId1);

        //删除标签
        JSONObject deleteTag1=new JSONObject();
        deleteTag1.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        deleteTag1.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        deleteTag1.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        deleteTag1.put("id",tagId1);
        deleteTag1.put("confirm",true);

        xmAppApi.doRequest(RequestType.JSON,params,deleteTag1.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String result=response.getJSONObject("result").getString("success");
        Assert.assertEquals(result,"true","删除已被本场馆使用标签失败");

        //验证是否被删除成功
        //查询当前列表中还有没有这个标签
        JSONObject fetchPage=tagTools.tagFetchPage("自动化标签勿动1");
        int total=Integer.parseInt(fetchPage.getJSONObject("result").getString("total"));
        Assert.assertEquals(0,total,"已被本场馆使用标签删除失败");
    }

    @Test(description = "删除标签--已被非本场馆会员使用-不能删除")
    public void testDeleteById_2() {
        //被别的场馆使用：tagId：1801151244447690753-自动化标签勿动;memberId：1801150921062658049-自动化标签会员勿动1
        //删除标签
        JSONObject deleteTag2=new JSONObject();
        deleteTag2.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        deleteTag2.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        deleteTag2.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        deleteTag2.put("id","1801151244447690753");
        deleteTag2.put("confirm","");

        xmAppApi.doRequest(RequestType.JSON,params,deleteTag2.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String result=response.getJSONObject("result").getString("success");
        Assert.assertEquals(result,"false","删除已被非本场馆会员使用的标签失败");

    }
    }
