package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-05-07  17:06
 * @Description: 创建团课
 * @Version: 1.0
 */
public class TestCreateGroupCourse extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;

    private String courseId;
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Course, "API_createGroupCourse", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }


    @Test
    public void testCreateGroupCourse() {
        // 查询存量的课程分类
        String categoryId = courseCategoryTools.getCourseCategoryPage("瑜伽");

        String courseName = "瑜伽团课" + TimeUtils.getCurrentTime();
        Random random = new Random();
        int duration = random.nextInt(60)+10; // 时长
        int difficulty = random.nextInt(5)+1; // 难度
        int calorie = random.nextInt(100)+100;
        String introduction = "{\"items\":[{\"content\":\"花花世界的\",\"aspect\":\"\",\"type\":\"TEXT\"}]}";

        JSONObject body= new JSONObject();
        body.put("courseName", courseName);
        body.put("duration", duration);      // 时长
        body.put("difficulty", difficulty);     // 难度
        body.put("color", "#AACF53");
        body.put("coverId", "0");
        body.put("timeUnit", "MINUTE");
        body.put("categoryId", categoryId);
        body.put("introduction", introduction);
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("sourceId", xmAppApi.getLoginInfo().getStudioId());  // 来源：场馆、品牌
        body.put("sourceType", "STUDIO");
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());  // 品牌
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId()); // 场馆
        body.put("calorie", calorie);
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        // 获取课程id
        courseId = xmAppApi.getBodyInJSON().getString("result");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // check 1：列表是否有该团课数据
        JSONObject coursePage = courseTools.getGroupClassPage("ON",0,courseName,categoryId);
        String total = coursePage.getString("total");
        Assert.assertEquals(total,"1","新建之后团课列表没有找到相关数据");

        // check 2：团课详情内容是否与新建一致
        String[] keys = {"courseName","duration","difficulty","color","coverId","timeUnit","categoryId","sourceId","sourceType","brandId","calorie"};
        String[] values = {courseName,String.valueOf(duration),String.valueOf(difficulty),"#AACF53","0","MINUTE",categoryId,xmAppApi.getLoginInfo().getStudioId(),"STUDIO",xmAppApi.getLoginInfo().getBrandId(),String.valueOf(calorie)};

        JSONObject courseDetail = courseTools.getCourseDetail(courseId);
        for (int i = 0; i < keys.length; i++) {
            String result = values[i];
            Assert.assertEquals(courseDetail.getString(keys[i]),result,"新建之后课程详情与新建内容不一致");
        }
    }

    @Test(description = "清除增量数据",priority = 1)
    public void del(){
        // 删除课程数据
        courseTools.modifyCourseStatus(courseId,"DELETE",false);
    }
}
