package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestSumMemberVoucherAmount extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumMemberVoucherAmount")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取会员详情-订单管理金额统计")
    public void testSumMemberVoucherAmount(){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("receiverId","1777254935106740226");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"true","获取会员详情-订单管理金额统计失败");


        float totalActualAmount= Float.parseFloat(response.getJSONObject("result").getString("totalActualAmount"));
        float totalUnpaidAmount=Float.parseFloat(response.getJSONObject("result").getString("totalUnpaidAmount"));

        boolean flag=true;
        if(totalActualAmount < 0){
            flag=false;
        }
        Assert.assertEquals(flag,true,"获取会员详情-订单金额统计小于0");
    }


    @Test(description = "获取会员详情-订单管理金额统计-无会员ID")
    public void testSumMemberVoucherAmount1() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("supplierId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("receiverId", "");
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(false);

    }

}
