package com.xiaomai.cases.polar.setting.tag;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.setting.TagTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


public class TestDeleteById extends XMBaseTest {

    TagTools tagTools=new TagTools();


    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_deleteById")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "删除标签--未被会员使用")
    public void testDeleteById(){

        //获取当前标签列表
        JSONObject fetchPage=tagTools.tagFetchPage("");
        int total= Integer.parseInt(fetchPage.getJSONObject("result").getString("total"));

        //添加标签
        JSONObject createTag=tagTools.tagCreate("自动化"+ RandomStringUtil.randomString(3));
        String tagId=createTag.getString("result");

        //删除标签
        JSONObject deleteTag=new JSONObject();
        deleteTag.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        deleteTag.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        deleteTag.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        deleteTag.put("id",tagId);
        deleteTag.put("confirm","");

        xmAppApi.doRequest(RequestType.JSON,params,deleteTag.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String result=response.getJSONObject("result").getString("success");
        Assert.assertEquals(result,"true","删除标签失败");

        //获取当前标签列表
        JSONObject fetchPage2=tagTools.tagFetchPage("");
        int total2= Integer.parseInt(fetchPage2.getJSONObject("result").getString("total"));
        Assert.assertEquals(total2,total,"删除标签失败");

    }
//    @Test(description = "删除标签--已被会员使用")//待添加线索之后再补充
}
