package com.xiaomai.cases.polar.setting.tag;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.setting.TagTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestEdit extends XMBaseTest {

    TagTools tagTools=new TagTools();

    String tagId;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_edit")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "编辑标签--未被会员使用")
    public void testEdit(){

        //添加标签
        JSONObject createTag=tagTools.tagCreate("自动化专用"+RandomStringUtil.randomString(2));
        tagId=createTag.getString("result");

        //编辑标签
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("label","自动化编辑"+RandomStringUtil.randomString(2));
        jsonObject.put("id",tagId);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getJSONObject("result").getString("success");
        Assert.assertEquals(success,"true","编辑标签失败");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

//    @Test(description = "编辑标签--已被会员使用")//待添加线索之后再补充

    //删除标签
    @Test(description = "删除标签",priority = 1)
    public void deleteTag(){
        tagTools.tagDelete(tagId);
    }
}
